
# script_webcalendar_desc()
sub script_webcalendar_desc
{
return "WebCalendar";
}

sub script_webcalendar_uses
{
return ( "php" );
}

sub script_webcalendar_longdesc
{
return "A PHP application used to maintain a calendar for one or more persons and for a variety of purposes.";
}

# script_webcalendar_versions()
sub script_webcalendar_versions
{
return ( "1.2.7" );
}

sub script_webcalendar_category
{
return "Calendar";
}

sub script_webcalendar_php_vers
{
return ( 5 );
}

sub script_webcalendar_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql", "gd") : ("pgsql", "gd");
}

sub script_webcalendar_dbs
{
return ("mysql", "postgres");
}

# script_webcalendar_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_webcalendar_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for WebCalendar tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for WebCalendar tables",
		     &ui_database_select("db", undef, \@dbs, $d,"webcalendar"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("webcalendar", $d), 30, "At top level"));
	$rv .= &ui_table_row("Single-user mode?",
			     &ui_yesno_radio("single", 0));
	}
return $rv;
}

# script_webcalendar_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_webcalendar_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}",
		 'single' => $in->{'single'}, };
	}
}

# script_webcalendar_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_webcalendar_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "WebCalendar appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "webcal_.*");
$clash && return "WebCalendar appears to be already using the selected database (table $clash)";
return undef;
}

# script_webcalendar_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_webcalendar_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "WebCalendar-$ver.tar.gz",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/webcalendar/WebCalendar-$ver.zip" } );
return @files;
}

sub script_webcalendar_commands
{
return ("unzip");
}

# script_webcalendar_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs WebCalendar, and returns either 1 and an informational
# message, or 0 and an error
sub script_webcalendar_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "postgresql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "WebCalendar-$ver");
$err && return (0, "Failed to extract source : $err");
local $cfileorig = "$opts->{'dir'}/includes/settings.php.orig";
local $cfile = "$opts->{'dir'}/includes/settings.php";

if (!-r $cfile) {
	# Copy and update the config file
	&run_as_domain_user($d, "cp ".quotemeta($cfileorig)." ".
				      quotemeta($cfile));
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach $l (@$lref) {
		if ($l =~ /^db_type:/) { $l = "db_type: $dbphptype"; }
		if ($l =~ /^db_login:/) { $l = "db_login: $dbuser"; }
		if ($l =~ /^db_password:/) { $l = "db_password: $dbpass"; }
		if ($l =~ /^db_database:/) { $l = "db_database: $dbname"; }
		if ($l =~ /^db_host:/) { $l = "db_host: $dbhost"; }
		if ($opts->{'single'}) {
			if ($l =~ /^single_user:/) { $l = "single_user: true"; }
			if ($l =~ /^(#*)single_user_login:/) { $l = "single_user_login: admin"; }
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);
	}

if (!$upgrade) {
	# Run the SQL setup script
	if ($dbtype eq "mysql") {
		local $sqlfile = "$opts->{'dir'}/install/sql/tables-mysql.sql";
		&require_mysql();
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
		}
	elsif ($dbtype eq "postgres") {
		local $sqlfile = "$opts->{'dir'}/install/sql/tables-postgres.sql";
		&require_postgres();
		($ex, $out) = &postgresql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run database setup script in $dbname : <tt>$out</tt>.");
		}
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $loginmsg = $opts->{'single'} ? "" : "The initial login is <i>admin</i> with password <i>admin</i>.";
return (1, "WebCalendar installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>. ".$loginmsg, "Under $rp using $dbphptype database $dbname", $url);
}

# script_webcalendar_uninstall(&domain, version, &opts)
# Un-installs a PHP-Nuke installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_webcalendar_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all webcal_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "webcal_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "WebCalendar directory and tables deleted.");
}

# script_webcalendar_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_webcalendar_php_vars
{
return ( [ 'magic_quotes_gpc', 'On' ] );
}

# script_webcalendar_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_webcalendar_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("webcalendar", "WebCalendar-([0-9\\.]+)\\.zip");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_webcalendar_site
{
return 'http://webcalendar.sourceforge.net/';
}

1;

