
# script_turba_desc()
sub script_turba_desc
{
return "Turba";
}

sub script_turba_uses
{
return ( "php", "horde" );
}

sub script_turba_longdesc
{
return "Turba is the Horde contact management application. It is a production level address book, and makes heavy use of the Horde framework to provide integration with IMP and other Horde applications.";
}

# script_turba_versions()
sub script_turba_versions
{
return ( "h3-2.3.6" );
}

sub script_turba_category
{
return "Horde";
}

# script_turba_depends(&domain, version)
sub script_turba_depends
{
local ($d, $ver) = @_;

# Check for horde install
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
return ("Turba requires that Horde be installed first") if (!$horde);

return ( );
}

# script_turba_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_turba_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
        local $odir = $horde->{'opts'}->{'dir'};
        $odir =~ s/^\Q$d->{'home'}\E\///;
	$rv .= &ui_table_row("Install sub-directory under <tt>$odir</tt>",
			     &ui_textbox("dir", "turba", 30));
	}
return $rv;
}

# script_turba_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_turba_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local @scripts = &list_domain_scripts($d);
	local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$horde->{'opts'}->{'dir'}/$in{'dir'}";
	$dir =~ s/\/\//\//g;
        local $path = "$horde->{'opts'}->{'path'}/$in{'dir'}";
        $path =~ s/\/\//\//g;
	return { 'dir' => $dir,
		 'path' => $path,
		 'db' => $horde->{'opts'}->{'db'},
		 'horde' => 1 };
	}
}

# script_turba_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_turba_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "Turba appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "turba_.*");
$clash && return "Turba appears to be already using the selected database (table $clash)";
return undef;
}

# script_turba_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Turba, each of which is a hash ref
# containing a name, filename and URL
sub script_turba_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "turba-$ver.tar.gz",
	   'url' => "ftp://ftp.horde.org/pub/turba/turba-$ver.tar.gz" } );
return @files;
}

sub script_turba_commands
{
return ("tar", "gunzip");
}

# script_turba_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Turba, and returns either 1 and an informational
# message, or 0 and an error
sub script_turba_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "turba-$ver");
$err && return (0, "Failed to extract source : $err");

# Copy the config files
local $cdir = "$opts->{'dir'}/config";
opendir(DIR, $cdir);
foreach my $f (readdir(DIR)) {
	if ($f =~ /^(.*)\.dist$/ && !-r "$cdir/$1") {
		&run_as_domain_user($d, "cp ".quotemeta("$cdir/$f")." ".
					      quotemeta("$cdir/$1"));
		&make_file_php_writable($d, "$cdir/$1");
		}
	}
closedir(DIR);
&make_file_php_writable($d, $cdir);

# Execute the SQL file
if (!$upgrade) {
	local ($dbtype, $dbname) = split(/_/, $horde->{'opts'}->{'db'}, 2);
	local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
	local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
	if ($dbtype eq "mysql") {
		&require_mysql();
		local $sqlfile = "$opts->{'dir'}/scripts/sql/turba.sql";
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (-1, "Failed to run database setup script : <tt>$out</tt>.");
		}
	elsif ($dbtype eq "postgres") {
		&require_postgres();
		local $sqlfile = "$opts->{'dir'}/scripts/sql/turba.pgsql.sql";
		($ex, $out) = &postgresql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
		$ex && return (-1, "Failed to run database setup script : <tt>$out</tt>.");
		}
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Turba installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>. However, it must first be configured using Horde at <a target=_blank href='$horde->{'url'}'>$horde->{'url'}</a>, on the Setup page under Administration.", "Under $rp", $url);
}

# script_turba_uninstall(&domain, version, &opts)
# Un-installs a Turba installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_turba_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove turba tables from the horde database
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
local ($dbtype, $dbname) = split(/_/, $horde->{'opts'}->{'db'}, 2);
&cleanup_script_database($d, $horde->{'opts'}->{'db'}, "turba_");

return (1, "Turba directory and tables deleted.");
}

# script_turba_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_turba_latest
{
return ( "http://ftp.horde.org/pub/turba/",
         "turba-(h3-[0-9\\.]+)\\.tar\\.gz" );
}

sub script_turba_site
{
return 'http://www.horde.org/turba/';
}

1;

