
# script_simpleinvoices_desc()
sub script_simpleinvoices_desc
{
return "Simple Invoices";
}

sub script_simpleinvoices_uses
{
return ( "php" );
}

sub script_simpleinvoices_longdesc
{
return "Simple Invoices is a simple, community developed, free/open source, web-based invoicing system.";
}

# script_simpleinvoices_versions()
sub script_simpleinvoices_versions
{
return ( "2011.1" );
}

sub script_simpleinvoices_category
{
return "Commerce";
}

sub script_simpleinvoices_php_vers
{
return ( 5 );
}

sub script_simpleinvoices_php_modules
{
return ("mysql", "gd");
}

sub script_simpleinvoices_dbs
{
return ("mysql");
}

# script_simpleinvoices_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_simpleinvoices_php_vars
{
return ( [ 'memory_limit', '24M', '+' ] );
}

# script_simpleinvoices_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_simpleinvoices_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Simple Invoices tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for Simple Invoices tables",
		     &ui_database_select("db", undef, \@dbs, $d, "simpleinvoices"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("simpleinvoices", $d), 30, "At top level"));
	}
return $rv;
}

# script_simpleinvoices_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_simpleinvoices_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_simpleinvoices_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_simpleinvoices_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "Simple Invoices appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "si_.*");
$clash && return "Simple Invoices appears to be already using the selected database (table $clash)";
return undef;
}

# script_simpleinvoices_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Simple Invoices, each of which is a hash ref
# containing a name, filename and URL
sub script_simpleinvoices_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "simpleinvoices_${ver}.zip",
	   'method' => 'GET',
	   'url' => "http://simpleinvoices.googlecode.com/files/simpleinvoices.${ver}.zip" } );
return @files;
}

sub script_simpleinvoices_commands
{
return ("unzip");
}

# script_simpleinvoices_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Simple Invoices, and returns either 1 and an informational
# message, or 0 and an error
sub script_simpleinvoices_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;

# Get DB details
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Copy old config file
local $oldcfile = &transname();
local $oldinifile = &transname();
local $cfile = "$opts->{'dir'}/config/config.php";
local $inifile = "$opts->{'dir'}/config/config.ini";
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	&copy_source_dest($inifile, $oldinifile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
				     $opts->{'dir'}, "simpleinvoices");
$err && return (0, "Failed to extract source : $err");

# Make needed directories writable
foreach my $dir ("cache", "library/pdf/fpdf", "database_backups") {
	&make_file_php_writable($d, "$opts->{'dir'}/$dir");
	}

if ($upgrade) {
	# Put back config file(s)
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	&copy_source_dest_as_domain_user($d, $oldinifile, $inifile);
	}
else {
	# Update the config file
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^\s*\$db_host\s*=/) {
			$l = "\$db_host = \"$dbhost\";";
			}
		if ($l =~ /^\s*\$db_name\s*=/) {
			$l = "\$db_name = \"$dbname\";";
			}
		if ($l =~ /^\s*\$db_user\s*=/) {
			$l = "\$db_user = \"$dbuser\";";
			}
		if ($l =~ /^\s*\$db_password\s*=/) {
			$l = "\$db_password = \"".&php_quotemeta($dbpass)."\";";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	# Update the ini file
	local $lref = &read_file_lines_as_domain_user($d, $inifile);
	foreach my $l (@$lref) {
		if ($l =~ /^\s*database.params.host\s*=/) {
			$l = "database.params.host = $dbhost";
			}
		if ($l =~ /^\s*database.params.username\s*=/) {
			$l = "database.params.username = $dbuser";
			}
		if ($l =~ /^\s*database.params.password\s*=/) {
			$l = "database.params.password = $dbpass";
			}
		if ($l =~ /^\s*database.params.dbname\s*=/) {
			$l = "database.params.dbname = $dbname";
			}
		}
	&flush_file_lines_as_domain_user($d, $inifile);
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial Simple Invoices installation complete. Go to <a target=_blank href='$url'>$url</a> to complete the process.", "Under $rp using $dbphptype database $dbname", $url);
}

# script_simpleinvoices_uninstall(&domain, version, &opts)
# Un-installs a Simple Invoices installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_simpleinvoices_uninstall
{
local ($d, $version, $opts) = @_;

# Remove simpleinvoices tables from the database
&cleanup_script_database($d, $opts->{'db'}, "si_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Simple Invoices directory and tables deleted.");
}

# script_simpleinvoices_latest(version)
sub script_simpleinvoices_latest
{
local ($ver) = @_;
return ( "http://www.simpleinvoices.org/go",
	 "simpleinvoices\\.([0-9\\.]+)\\.zip" );
}

sub script_simpleinvoices_site
{
return 'http://www.simpleinvoices.org/';
}

1;

