
# script_postnuke_desc()
sub script_postnuke_desc
{
return "PostNuke";
}

sub script_postnuke_disabled
{
return 2;	# Superceded by Zikula, and no longer available for download
}

sub script_postnuke_uses
{
return ( "php" );
}

sub script_postnuke_longdesc
{
return "A flexible Open Source content management system.";
}

# script_postnuke_versions()
sub script_postnuke_versions
{
return ( "0.764" );
}

sub script_postnuke_category
{
return "Content Management System";
}

sub script_postnuke_php_vers
{
return (4, 5);
}

sub script_postnuke_php_modules
{
return ("mysql");
}

sub script_postnuke_dbs
{
return ("mysql");
}

# script_postnuke_depends(&domain, version)
sub script_postnuke_depends
{
local ($d, $ver) = @_;
local @rv;
&require_mysql();
if (&mysql::get_mysql_version() < 4.1) {
	push(@rv, "PostNuke requires MySQL version 4.1 or higher");
	}
return @rv;
}

# script_postnuke_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_postnuke_php_vars
{
return ( [ 'register_globals', 'Off' ] );
}

# script_postnuke_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_postnuke_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for PostNuke tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for PostNuke tables",
		     &ui_database_select("db", undef, \@dbs, $d, "postnuke"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("postnuke", $d), 30, "At top level"));
	}
return $rv;
}

# script_postnuke_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_postnuke_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_postnuke_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_postnuke_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "PostNuke appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "pn_.*");
$clash && return "PostNuke appears to be already using the selected database (table $clash)";
return undef;
}

# script_postnuke_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PostNuke, each of which is a hash ref
# containing a name, filename and URL
sub script_postnuke_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "PostNuke-$ver.tar.gz",
	   'url' => "http://noc.postnuke.com/frs/download.php/1340/PostNuke-$ver.tar.gz" } );
return @files;
}

sub script_postnuke_commands
{
return ("tar", "gunzip");
}

# script_postnuke_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PostNuke, and returns either 1 and an informational
# message, or 0 and an error
sub script_postnuke_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Save old config files
local $cfile = "$opts->{'dir'}/config.php";
local $cfileold = "$opts->{'dir'}/config-old.php";
local ($cfile_copy, $cfileold_copy);
if ($upgrade) {
	$cfile_copy = &transname();
	$cfileold_copy = &transname();
	&copy_source_dest($cfile, $cfile_copy);
	&copy_source_dest($cfileold, $cfileold_copy);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "PostNuke-$ver/html");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
local $noslash = $url;
$noslash =~ s/\/$//;
if ($upgrade) {
	# Put back config files
	&copy_source_dest_as_domain_user($d, $cfile_copy, $cfile);
	&copy_source_dest_as_domain_user($d, $cfileold_copy, $cfileold);
	}
else {
	# Use HTTP request to setup

	# Make config.php writable
	&make_file_php_writable($d, $cfile);
	&make_file_php_writable($d, "$opts->{'dir'}/config-old.php");
	&make_file_php_writable($d, "$opts->{'dir'}/pnTemp");

	# Trigger the DB setup PHP script
	local @params = (
		[ "dbhost", $dbhost ],
		[ "dbuname", $dbuser ],
		[ "dbpass", $dbpass ],
		[ "dbname", $dbname ],
		[ "prefix", "pn" ],
		[ "dbtype", "mysql" ],
		[ "dbtabletype", "myisam" ],
		[ "currentlang", "eng" ],
		[ "op", "Start" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php";

	# Make an HTTP post to the DB setup page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "PostNuke database configuration failed : $ierror");
		}
	elsif ($iout !~ /pn_admin_category\s+made/) {
		return (-1, "PostNuke database configuration failed");
		}

	# Trigger the admin user PHP script
	push(@params,
		[ "aid", $domuser ],
		[ "name", $d->{'owner'} ],
		[ "pwd", $dompass ],
		[ "repeatpwd", $dompass ],
		[ "email", $d->{'emailto_addr'} ],
		[ "url", $slashurl ],
		);
	foreach my $p (@params) {
		$p->[1] = "Set Login" if ($p->[0] eq "op");
		}
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);

	# Make an HTTP post to the DB setup page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "PostNuke admin configuration failed : $ierror");
		}
	elsif ($iout !~ /pn_headlines\s+updated/) {
		#return (-1, "PostNuke admin configuration failed");
		}

	# Make config.php read-only
	&make_file_php_writable($d, "$opts->{'dir'}/config-old.php");
	}
&make_file_php_nonwritable($d, $cfile);

# Delete the installer script and files
&run_as_domain_user($d,
	"rm -rf ".quotemeta("$opts->{'dir'}/install.php")." ".
		  quotemeta("$opts->{'dir'}/install"));

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "PostNuke installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_postnuke_uninstall(&domain, version, &opts)
# Un-installs a PostNuke installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_postnuke_uninstall
{
local ($d, $version, $opts) = @_;

# Remove postnuke tables from the database
&cleanup_script_database($d, $opts->{'db'}, "pn_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "PostNuke directory and tables deleted.");
}

# script_postnuke_latest(version)
# Returns a URL and regular expression or callback func to get the version
# Disabled, as it is no longer maintained
#sub script_postnuke_latest
#{
#return ( "http://noc.postnuke.com/frs/?group_id=5&release_id=700",
#	 "PostNuke-([0-9\\.]+).tar.gz" );
#}

sub script_postnuke_site
{
return 'http://www.postnuke.com/';
}

sub script_postnuke_passmode
{
return 1;
}

1;

