
# script_pollphp_desc()
sub script_pollphp_desc
{
return "Advanced Poll";
}

sub script_pollphp_uses
{
return ( "php" );
}

sub script_pollphp_longdesc
{
return "Advanced Poll is a polling system with powerful administration tool.";
}

# script_pollphp_versions()
sub script_pollphp_versions
{
return ( "2.0.9" );
}

sub script_pollphp_category
{
return "Survey";
}

sub script_pollphp_php_vers
{
return ( 5 );
}

# script_pollphp_php_vars(&domain)
sub script_pollphp_php_vars
{
return ( [ 'register_long_arrays', 'On' ] );
}

# script_pollphp_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_pollphp_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("poll", $d), 30, "At top level"));
	}
return $rv;
}

# script_pollphp_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_pollphp_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_pollphp_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_pollphp_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/admin/config.inc.php") {
	return "Advanced Poll appears to be already installed in the selected directory";
	}
return undef;
}

# script_pollphp_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_pollphp_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "pollphp-${ver}.tar.gz",
	   'url' => "http://download.webmin.com/download/others/pollphp-2.0.9.tar.gz" } );
return @files;
}

sub script_pollphp_commands
{
return ("unzip");
}

# script_pollphp_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Advanced Poll, and returns either 1 and an informational
# message, or 0 and an error
sub script_pollphp_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "textfile");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/include/config.inc.php";

# Update the config file
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
	if ($l =~ /^\$pollvars\['base_url'\]\s*=/) {
		$l = "\$pollvars['base_url'] = \"$opts->{'path'}\";";
		}
	if ($l =~ /^\$pollvars\['base_gif'\]\s*=/) {
		$l = "\$pollvars['base_gif'] = \"$opts->{'path'}/image\";";
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

# Set file permissions
&make_file_php_writable($d, "$opts->{'dir'}/polldata");
&make_file_php_writable($d, "$opts->{'dir'}/templates", 1);
&make_file_php_writable($d, "$opts->{'dir'}/templates/default");
&make_file_php_writable($d, "$opts->{'dir'}/templates/graphic");
&make_file_php_writable($d, $cfile);

# Return a URL for the user
local $url = &script_path_url($d, $opts)."admin/";
local $userurl = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Advanced Poll installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp", $userurl, "admin", "poll");
}

# script_pollphp_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_pollphp_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "Advanced Poll directory deleted.");
}

#sub script_pollphp_site
#{
#return 'http://www.proxy2.de/scripts.php';
#}

# script_pollphp_latest(version)
# Returns a URL and regular expression or callback func to get the version
#sub script_pollphp_latest
#{
#return ( "http://proxy2.de/scripts.php",
#	 "Advanced\\s+Poll\\s+([0-9\\.]+)" );
#}

sub script_pollphp_abandoned
{
return 1;
}

1;

