
# script_phpsurveyor_desc()
sub script_phpsurveyor_desc
{
return "LimeSurvey";
}

sub script_phpsurveyor_uses
{
return ( "php" );
}

sub script_phpsurveyor_longdesc
{
return "LimeSurvey is a set of PHP scripts that interact with MySQL to develop surveys, publish surveys and collect responses to surveys.";
}

# script_phpsurveyor_versions()
sub script_phpsurveyor_versions
{
return ( "2.05plus-build140502" );
}

sub script_phpsurveyor_can_upgrade
{
local ($sinfo, $newver) = @_;
return $sinfo <= 2.00 ? 0 : 1;
}

sub script_phpsurveyor_category
{
return "Survey";
}

sub script_phpsurveyor_php_vers
{
local ($d, $version) = @_;
return ( 5 );
}

sub script_phpsurveyor_php_modules
{
return ("mysql", "mbstring");
}

sub script_phpsureyor_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;
# Check for PHP 5.3+
local $phpv = &get_php_version($phpver || 5, $d);
if (!$phpv) {
	push(@rv, "Could not work out exact PHP version");
	}
elsif ($phpv < 5.3) {
	push(@rv, "LimeSurvey and above requires PHP version 5.3 or later");
	}
return @rv;
}

sub script_phpsurveyor_dbs
{
return ("mysql");
}

# script_phpsurveyor_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing LimeSurvey
sub script_phpsurveyor_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for LimeSurvey tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for LimeSurvey tables",
		    &ui_database_select("db", undef, \@dbs, $d, "limesurvey"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("limesurvey", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpsurveyor_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpsurveyor_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpsurveyor_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpsurveyor_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "LimeSurvey appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "lime_.*");
$clash && return "LimeSurvey appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpsurveyor_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by LimeSurvey, each of which is a hash ref
# containing a name, filename and URL
sub script_phpsurveyor_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local $uver = $ver;
$uver =~ s/\.//g;
local @files = ( { 'name' => "source",
	   'file' => "limesurvey$uver.zip",
	   'url' => "http://download.limesurvey.org/Latest_stable_release/limesurvey${uver}.zip" } );
return @files;
}

sub script_phpsurvyeor_commands
{
return ("unzip");
}

# script_phpsurveyor_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs LimeSurvey, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpsurveyor_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

if ($upgrade && $upgrade->{'version'} <= 1.00) {
	# Upgrading from PHPsurveyor not supported
	return (0, "Upgrading from PHPsurveyor versions 1.00 or older is not supported");
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "limesurvey");
$err && return (0, "Failed to extract source : $err");
&make_file_php_writable($d, "$opts->{'dir'}/application/config", 1);

local $url = &script_path_url($d, $opts);
local $noslash = $url;
$noslash =~ s/\/$//;

if (!$upgrade) {
	# Request the welcome page, to get a session cookie
	local ($out, $error);
	&get_http_connection($d,"$opts->{'path'}/index.php?r=installer/welcome",
			     \$out, \$error, \&phpsurveyor_cookie_callback);
	if ($error) {
		return (-1, "Failed to get session cookie : $error");
		}
	elsif (!$phpsurveyor_session_cookie) {
		return (-1, "No session cookie found");
		}
	my $token = $phpsurveyor_session_cookie =~ /YII_CSRF_TOKEN=(\S+)/ ?
			$1 : undef;

	# Submit language form
	local @params = (
		[ "installerLang", "en" ],
		[ "yt0", "Next" ],
		[ "YII_CSRF_TOKEN", $token ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/index.php?r=installer/welcome";
	local ($out, $error);
	&post_http_connection($d, $ipage, $params, \$out, \$error,
		      { 'Cookie' => $phpsurveyor_session_cookie });
	if ($error) {
		return (-1, "Language selection failed : $error");
		}

	# Submit licence form
	local @params = (
		[ "YII_CSRF_TOKEN", $token ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/index.php?r=installer/license";
	local ($out, $error);
	&post_http_connection($d, $ipage, $params, \$out, \$error,
		      { 'Cookie' => $phpsurveyor_session_cookie });
	if ($error) {
		return (-1, "License acceptance failed : $error");
		}

	# Get database confirmation form
	local ($out, $error);
	&get_http_connection(
		$d, "$opts->{'path'}/index.php?r=installer/database",
	     	\$out, \$error, undef, 0, undef, undef, 0, 0, 0,
	     	{ 'Cookie' => $phpsurveyor_session_cookie });

	# Submit the database configuration form
	local @params = (
		[ "InstallerConfigForm[dbtype]", "mysql" ],
		[ "InstallerConfigForm[dblocation]", $dbhost ],
		[ "InstallerConfigForm[dbname]", $dbname ],
		[ "InstallerConfigForm[dbuser]", $dbuser ],
		[ "InstallerConfigForm[dbpwd]", $dbpass ],
		[ "InstallerConfigForm[dbprefix]", "lime_" ],
		[ "yt0", "Next" ],
		[ "YII_CSRF_TOKEN", $token ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/index.php?r=installer/database";
	local ($out, $error);
	&post_http_connection($d, $ipage, $params, \$out, \$error,
		      { 'Cookie' => $phpsurveyor_session_cookie });
	if ($error) {
		return (-1, "Database configuration failed : $error");
		}

	# Submit the database population form
	local @params = (
		[ "createdbstep2", "Populate database" ],
		[ "YII_CSRF_TOKEN", $token ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/index.php?r=installer/populatedb";
	local ($out, $error);
	&post_http_connection($d, $ipage, $params, \$out, \$error,
		      { 'Cookie' => $phpsurveyor_session_cookie });
	if ($error) {
		return (-1, "Database population failed : $error");
		}
	print STDERR $out,"\n";

	# Submit the user creation form
	local @params = (
		[ "InstallerConfigForm[adminLoginName]", $domuser ],
		[ "InstallerConfigForm[adminLoginPwd]", $dompass ],
		[ "InstallerConfigForm[confirmPwd]", $dompass ],
		[ "InstallerConfigForm[adminName]", "Administrator" ],
		[ "InstallerConfigForm[adminEmail]", $d->{'emailto'} ],
		[ "InstallerConfigForm[siteName]", "Limesurvey" ],
		[ "InstallerConfigForm[surveylang]", "en" ],
		[ "yt0", "Next" ],
		[ "YII_CSRF_TOKEN", $token ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/index.php/installer/optional";
	local ($out, $error);
	&post_http_connection($d, $ipage, $params, \$out, \$error,
		      { 'Cookie' => $phpsurveyor_session_cookie });
	if ($error) {
		return (-1, "User creation failed : $error");
		}
	}

# Delete the admin/install directory
&run_as_domain_user($d, "rm -rf ".
			quotemeta("$opts->{'dir'}/admin/install"));

# Set some permissions
&make_file_php_writable($d, "$opts->{'dir'}/admin", 1);
&make_file_php_writable($d, "$opts->{'dir'}/tmp");
&make_file_php_writable($d, "$opts->{'dir'}/upload");

# Return a URL for the user
local $userurl = $url;
$url .= "admin/admin.php";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "LimeSurvey installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp using $dbphptype database $dbname", $userurl, $domuser, $dompass);
}

# script_phpsurveyor_uninstall(&domain, version, &opts)
# Un-installs a LimeSurvey installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpsurveyor_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all surveyor tables from the database
&cleanup_script_database($d, $opts->{'db'}, "lime_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "LimeSurvey directory and tables deleted.");
}

# script_phpsurveyor_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_phpsurveyor_latest
{
local ($ver) = @_;
return ( "http://www.limesurvey.org/stable-release",
	 "limesurvey20([a-z0-9\-]+).zip",
	 "2.0" );
}

sub script_phpsurveyor_site
{
return 'http://www.limesurvey.org/';
}

sub script_phpsurveyor_passmode
{
return 1;
}

sub phpsurveyor_cookie_callback
{
my @cl;
foreach my $h (@WebminCore::headers) {
	if ($h->[0] eq 'set-cookie' && $h->[1] =~ /((PHPSESSID|YII_CSRF_TOKEN)=([^ ;]+))/) {
		push(@cl, $1);
		}
	}
$phpsurveyor_session_cookie = join("; ", @cl);
}



1;

