
@phprojekt_tables = ("calendar", "configuration", "contact", "database_manager", "filemanager", "frontend_message", "groups", "groups_user_relation", "helpdesk", "history", "item_rights", "minutes", "minutes_item", "module", "module_tab_relation", "note", "project", "project_module_permissions", "project_role_user_permissions", "role", "role_module_permissions", "search_display", "search_word_module", "search_words", "setting", "tab", "tags", "tags_modules", "tags_users", "timecard", "todo", "user");

# script_phprojekt_desc()
sub script_phprojekt_desc
{
return "PHProjekt";
}

sub script_phprojekt_uses
{
return ( "php" );
}

sub script_phprojekt_longdesc
{
return "PHProjekt is a modular application for the coordination of group activities and to share informations and document via intranet and internet.";
}

# script_phprojekt_versions()
sub script_phprojekt_versions
{
return ( "6.0.6" );
}

sub script_phprojekt_abandoned
{
return 2;
}

# script_phprojekt_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_phprojekt_php_vars
{
return ( [ 'magic_quotes_gpc', 'Off' ] );
}

sub script_phprojekt_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($newver >= 6 && $sinfo->{'version'} < 6) {
	# Version 5 -> 6 upgrades not supported
	return 0;
	}
return 1;
}

sub script_phprojekt_category
{
return "Project Management";
}

sub script_phprojekt_php_vers
{
return ( 5 );
}

sub script_phprojekt_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_phprojekt_dbs
{
return ("mysql", "postgres");
}

# script_phprojekt_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_phprojekt_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for PHProjekt tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for PHProjekt tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phprojekt"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", "phprojekt", 30,
					     "At top level"));
	}
return $rv;
}

# script_phprojekt_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phprojekt_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phprojekt_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phprojekt_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/config.inc.php") {
	return "PHProjekt appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phpr_.*");
$clash && return "PHProjekt appears to be already using the selected database (table $clash)";
return undef;
}

# script_phprojekt_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_phprojekt_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "phprojekt-$ver.zip",
	   'nocache' => 1,
	   'nocheck' => 1,
	   'virtualmin' => 1,
	   'url' => "http://www.phprojekt.com/downloads/phprojekt.zip" } );
return @files;
}

sub script_phprojekt_commands
{
return ("unzip");
}

# script_phprojekt_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PHProjekt, and returns either 1 and an informational
# message, or 0 and an error
sub script_phprojekt_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "phprojekt-*");
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
local $errlog = "$opts->{'dir'}/logs/err.log";
local $debuglog = "$opts->{'dir'}/logs/debug.log";

# Make sure upload and logs dirs are writable
foreach my $dir ("upload", "logs", "tmp", "application", "upload/zendCache") {
	my $path = "$opts->{'dir'}/$dir";
	if (!-d $path) {
		&make_dir_as_domain_user($d, $path, 0755);
		}
	&make_file_php_writable($d, $path, 1);
	}

if (!$upgrade) {
	# Run DB setup SQL
	&require_mysql();
	local $sqlfile = "$opts->{'dir'}/docs/blank_database.sql";
	local ($ex, $out) = &mysql::execute_sql_file(
				$dbname, $sqlfile, $dbuser, $dbpass);
	$ex && return (-1,
		"Failed to run database setup script : <tt>$out</tt>.");

	# Set initial username password and email
	&mysql::execute_sql($dbname,
	    "update user set username = '$domuser' where username = 'admin'");
	&mysql::execute_sql($dbname,
	    "update setting set value = '$d->{'emailto'}' where key_value = 'email'");

	# Copy and edit config file
	local $cfile = "$opts->{'dir'}/configuration.php";
	local $cfilesrc = "$opts->{'dir'}/configuration.php-dist";
	&copy_source_dest_as_domain_user($d, $cfilesrc, $cfile);
	local $lref = &read_file_lines_as_domain_user($d, $cfile);
	foreach my $l (@$lref) {
		if ($l =~ /^language\s*=/) {
			$l = "language = \"en\"";
			}
		if ($l =~ /^webpath\s*=/) {
			$l = "webpath = \"${url}htdocs/\"";
			}
		if ($l =~ /^uploadPath\s*=/) {
			$l = "uploadPath = \"$opts->{'dir'}/upload/\"";
			}
		if ($l =~ /^tmpPath\s*=/) {
			$l = "tmpPath = \"$opts->{'dir'}/upload/\"";
			}
		if ($l =~ /^applicationPath\s*=/) {
			$l = "applicationPath = \"$opts->{'dir'}/application/\"";
			}
		if ($l =~ /^database.params.host\s*=/) {
			$l = "database.params.host = \"$dbhost\"";
			}
		if ($l =~ /^database.params.username\s*=/) {
			$l = "database.params.username = \"$dbuser\"";
			}
		if ($l =~ /^database.params.password\s*=/) {
			$l = "database.params.password = \"$dbpass\"";
			}
		if ($l =~ /^database.params.dbname\s*=/) {
			$l = "database.params.dbname = \"$dbname\"";
			}
		if ($l =~ /^log.err.filename\s*=/) {
			$l = "log.err.filename = \"$errlog\"";
			}
		if ($l =~ /^log.debug.filename\s*=/) {
			$l = "log.debug.filename = \"$debuglog\"";
			}
		}
	&flush_file_lines_as_domain_user($d, $cfile);

	# Create empty log files
	foreach my $log ($errlog, $debuglog) {
		&open_tempfile_as_domain_user($d, PLOG, ">$log", 0, 1);
		&close_tempfile_as_domain_user($d, PLOG);
		&make_file_php_writable($d, $log);
		}
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "PHProjekt installation complete. Go to <a target=_new href='$url'>$url</a> to use it.", "Under $rp", $url, $domuser, 'test');
}

# script_phprojekt_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phprojekt_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

if ($opts->{'db'}) {
	# Remove all phpr_ and phprojekt tables from the database
	&cleanup_script_database($d, $opts->{'db'}, "phpr_");
	&cleanup_script_database($d, $opts->{'db'}, \@phprojekt_tables);

	# Take out the DB
	if ($opts->{'newdb'}) {
		&delete_script_database($d, $opts->{'db'});
		}

	return (1, "PHProjekt directory and tables deleted.");
	}
else {
	return (1, "PHProjekt directory deleted.");
	}
}

sub script_phprojekt_passmode
{
return 3;
}

1;

