
# script_phplist_desc()
sub script_phplist_desc
{
return "PHPList";
}

sub script_phplist_uses
{
return ( "php" );
}

sub script_phplist_longdesc
{
return "PHPlist is a web application that implements a personalised mailing list manager or customer relationship management (CRM) system.";
}

# script_phplist_versions()
sub script_phplist_versions
{
return ( "3.0.6", "2.11.10" );
}

sub  script_phplist_version_desc
{
local ($ver) = @_;
return $ver < 3 ? "$ver (Old)" : "$ver (Stable)";
}

sub script_phplist_category
{
return "Email";
}

sub script_phplist_php_vers
{
local ($d, $ver) = @_;
return ( 5 );
}

sub script_phplist_php_modules
{
return ("mysql");
}

sub script_phplist_dbs
{
return ("mysql");
}

# script_phplist_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_phplist_php_vars
{
return ( [ 'magic_quotes_gpc', 'On' ],
	 [ 'magic_quotes_runtime', 'Off' ] );
}



# script_phplist_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_phplist_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for PHPList tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for PHPList tables",
		     &ui_database_select("db", undef, \@dbs, $d, "phplist"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phplist", $d), 30, "At top level"));
	}
return $rv;
}

# script_phplist_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phplist_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phplist_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phplist_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config/config.php") {
	return "PHPList appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phplist_.*");
$clash && return "PHPList appears to be already using the selected database (table $clash)";
return undef;
}

# script_phplist_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_phplist_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "phplist-$ver.zip",
	   'url' => "http://prdownloads.sourceforge.net/phplist/phplist-$ver.zip" } );
return @files;
}

sub script_phplist_commands
{
return ("unzip");
}

# script_phplist_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PHPList, and returns either 1 and an informational
# message, or 0 and an error
sub script_phplist_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
			     $opts->{'dir'}, "phplist-$ver/public_html/lists");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/config/config.php";

# Update config file
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
	if ($l =~ /^\$database_name\s*=/) {
		$l = "\$database_name = \"$dbname\";";
		}
	if ($l =~ /^\$database_user\s*=/) {
		$l = "\$database_user = \"$dbuser\";";
		}
	if ($l =~ /^\$database_host\s*=/) {
		$l = "\$database_host = \"$dbhost\";";
		}
	if ($l =~ /^\$database_password\s*=/) {
		$l = "\$database_password = \"".&php_quotemeta($dbpass)."\";";
		}
	if ($l =~ /^\$pageroot\s*=/) {
		$l = "\$pageroot = \"$opts->{'path'}\";";
		}
	if ($l =~ /^\$adminpages\s*=/) {
		$l = "\$adminpages = \"$opts->{'path'}/admin\";";
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

# Delete index.html file, as it can overshadow index.php
&unlink_file_as_domain_user($d, "$opts->{'dir'}/index.html");

# Remove mod_php directive from .htaccess
local $htfile = "$opts->{'dir'}/.htaccess";
if (-r $htfile) {
	local $lref = &read_file_lines_as_domain_user($d, $htfile);
	foreach my $l (@$lref) {
		if ($l =~ /^\s*php_flag/) {
			$l = "# ".$l;
			}
		}
	&flush_file_lines_as_domain_user($d, $htfile);
	}

# Return a URL for the user
local $userurl = &script_path_url($d, $opts);
local $url = &script_path_url($d, $opts)."admin/";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial PHPList installation complete. Go to <a target=_blank href='$url'>$url</a> to complete the installation process.", "Under $rp using $dbphptype database $dbname", $userurl, "admin", "phplist");
}

# script_phplist_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phplist_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all phplist_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "phplist_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "PHPList directory and tables deleted.");
}

# script_phplist_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_phplist_php_vars
{
return ( [ 'magic_quotes_gpc', 'On' ] );
}

# script_phplist_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_phplist_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("phplist", "phplist-([0-9\\.]+)\\.zip");
if ($ver < 3) {
       @vers = grep { $_ < 3 } @vers;
       }
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_phplist_site
{
return 'http://www.phplist.com/';
}

1;

