
# script_phpcalendar_desc()
sub script_phpcalendar_desc
{
return "PHP-Calendar";
}

sub script_phpcalendar_uses
{
return ( "php" );
}

sub script_phpcalendar_longdesc
{
return "A web-based calendar and event scheduled written in PHP.";
}

# script_phpcalendar_versions()
sub script_phpcalendar_versions
{
return ( "1.1" );
}

sub script_phpcalendar_category
{
return "Calendar";
}

sub script_phpcalendar_php_vers
{
return ( 5 );
}

sub script_phpcalendar_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_phpcalendar_dbs
{
return ("mysql", "postgres");
}

# script_phpcalendar_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-Calendar
sub script_phpcalendar_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for PHP-Calendar tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for PHP-Calendar tables",
		    &ui_database_select("db", undef, \@dbs, $d, "phpcalendar"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("phpcalendar", $d), 30, "At top level"));
	}
return $rv;
}

# script_phpcalendar_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_phpcalendar_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_phpcalendar_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_phpcalendar_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "PHP-Calendar appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "phpc_");
$clash && return "PHP-Calendar appears to be already using the selected database (table $clash)";
return undef;
}

# script_phpcalendar_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Calendar, each of which is a hash ref
# containing a name, filename and URL
sub script_phpcalendar_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = (
	 { 'name' => "source",
	   'file' => "php-calendar-$ver.tar.gz",
	   'url' => "http://code.google.com/p/php-calendar/downloads/detail?name=php-calendar-${ver}.tar.gz&can=2&q=" },
	 { 'name' => 'adodb',
	   'file' => "adodb495a.tgz",
	   'url' => "http://prdownloads.sourceforge.net/adodb/adodb495a.tgz" }
		);
return @files;
}

sub script_phpcalendar_commands
{
return ("tar", "bunzip2");
}

# script_phpcalendar_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs PHP-Calendar, and returns either 1 and an informational
# message, or 0 and an error
sub script_phpcalendar_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "mysql" : "psql";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config.php";
local $oldcfile = &transname();
if ($upgrade && -r $cfile) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "php-calendar-$ver");
$err && return (0, "Failed to extract source : $err");

# Extract AdoDB source in same dir
$out = &run_as_domain_user($d, "cd ".quotemeta($opts->{'dir'}).
			       " && gunzip -c $files->{'adodb'} | tar xf -");
-r "$opts->{'dir'}/adodb/adodb.inc.php" ||
	return (0, "Failed to extract AdoDB source : <tt>$out</tt>.");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Make config.php writable
	&make_file_php_writable($d, $cfile);

	# Trigger the installation PHP script
	local @params = (
		[ "config", 1 ],
		[ "my_hostname", $dbhost ],
		[ "my_database", $dbname ],
		[ "my_prefix", "phpc_" ],
		[ "my_username", $dbuser ],
		[ "my_passwd", $dbpass ],
		[ "sql_type", $dbtype ],
		[ "action", "Install" ]
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "PHP-Calendar post-install configuration failed : ".
			   $ierror);
		}

	# Call again to continue the process
	push(@params, [ "base", "continue" ]);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "PHP-Calendar post-install configuration failed : ".
			   $ierror);
		}

	# Call again to create the admin user
	push(@params, [ "admin_user", $domuser ],
		      [ "admin_pass", $dompass ]);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "PHP-Calendar account creation failed : ".$ierror);
		}

	# Remove install.php
	&unlink_file_as_domain_user($d, "$opts->{'dir'}/install.php");
	}

# Tell the user about the new install
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial PHP-Calendar installation complete. Go to <a target=_blank href='$url'>$url</a> to use it.", "Under $rp using $dbtype database $dbname", $url, $domuser, $dompass);
}

# script_phpcalendar_uninstall(&domain, version, &opts)
# Un-installs a PHP-Calendar installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_phpcalendar_uninstall
{
local ($d, $version, $opts) = @_;

# Remove phpcalendar tables from the database
&cleanup_script_database($d, $opts->{'db'}, "phpc_");

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Deleted PHP-Calendar directory and tables.");
}

sub script_phpcalendar_latest
{
local ($ver) = @_;
return ( "https://code.google.com/p/php-calendar/downloads/list",
	 "php-calendar-([0-9\\.]+).tar.gz" );
}

sub script_phpcalendar_site
{
return 'http://php-calendar.sourceforge.net/';
}

sub script_phpcalendar_passmode
{
return 1;
}

1;

