
# script_nucleus_desc()
sub script_nucleus_desc
{
return "Nucleus";
}

sub script_nucleus_uses
{
return ( "php" );
}

sub script_nucleus_longdesc
{
return "Maintains multiple weblogs.";
}

# script_nucleus_versions()
sub script_nucleus_versions
{
return ( "3.65" );
}

sub script_nucleus_category
{
return "Blog";
}

sub script_nucleus_php_vers
{
return ( 4, 5 );
}

sub script_nucleus_php_modules
{
return ("mysql");
}

sub script_nucleus_perl_modules
{
return ( "Digest::MD5" );
}

sub script_nucleus_dbs
{
return ("mysql");
}

# script_nucleus_depends(&domain, version)
sub script_nucleus_depends
{
local ($d, $ver) = @_;
local @rv;
local $mode = &get_domain_php_mode($d);
if ($mode eq "fcgid") {
	push(@rv, "Nucleus cannot be installed into virtual servers using the fCGId PHP execution mode");
	}
return @rv;
}

# script_nucleus_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_nucleus_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Nucleus tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Nucleus tables",
		     &ui_database_select("db", undef, \@dbs, $d, "nucleus"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("nucleus", $d), 30, "At top level"));
	}
return $rv;
}

# script_nucleus_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_nucleus_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_nucleus_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_nucleus_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/wp-login.php") {
	return "Nucleus appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "nucleus_.*");
$clash && return "Nucleus appears to be already using the selected database (table $clash)";
return undef;
}

# script_nucleus_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_nucleus_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "nucleus$ver.zip",
	   'url' => "http://osdn.dl.sourceforge.net/sourceforge/nucleuscms/nucleus$ver.zip" } );
return @files;
}

sub script_nucleus_commands
{
return ("unzip");
}

# script_nucleus_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Nucleus, and returns either 1 and an informational
# message, or 0 and an error
sub script_nucleus_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Preserve old config file
local $cfile = "$opts->{'dir'}/config.php";
local $oldcfile = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $oldcfile);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "nucleus$ver", 0, 1);
$err && return (0, "Failed to extract source : $err");

local $url = &script_path_url($d, $opts);
if ($upgrade) {
	# Put back original config file
	&copy_source_dest_as_domain_user($d, $oldcfile, $cfile);
	}
else {
	# Make config.php writable
	&make_file_php_writable($d, $cfile);

	# Trigger the installation PHP script
	local @params = (
		[ "mySQL_host", $dbhost ],
		[ "mySQL_user", $dbuser ],
		[ "mySQL_password", $dbpass ],
		[ "mySQL_database", $dbname ],
		[ "mySQL_usePrefix", 1 ],
		[ "mySQL_tablePrefix", "nucleus_" ],
		[ "IndexURL", $url ],
		[ "AdminURL", $url."nucleus/" ],
		[ "AdminPath", $opts->{'dir'}."/nucleus/" ],
		[ "MediaURL", $url."media/" ],
		[ "MediaPath", $opts->{'dir'}."/media/" ],
		[ "SkinsURL", $url."skins/" ],
		[ "SkinsPath", $opts->{'dir'}."/skins/" ],
		[ "PluginURL", $url."plugins/" ],
		[ "ActionURL", $url."action.php" ],
		[ "User_name", $domuser ],
		[ "User_realname", $d->{'owner'} ],
		[ "User_password", $dompass ],
		[ "User_password2", $dompass ],
		[ "User_email", $d->{'emailto_addr'} ],
		[ "Blog_name", "$d->{'dom'} Blog" ],
		[ "Blog_shortname", $d->{'prefix'} ],
		[ "action", "go" ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install.php";

	# Make an HTTP post to the installer page
	local ($iout, $ierror);
	&post_http_connection($d, $ipage, $params, \$iout, \$ierror);
	if ($ierror) {
		return (-1, "Nucleus post-install configuration failed : $ierror");
		}

	# Delete files used by install process
	&unlink_file_as_domain_user($d, "$opts->{'dir'}/install.sql",
				        "$opts->{'dir'}/install.php");
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Go to <a target=_blank href='$url'>$url</a> to use Nucleus.", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_nucleus_uninstall(&domain, version, &opts)
# Un-installs a PHP-Nuke installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_nucleus_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all nucleus_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "nucleus_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "Nucleus directory and tables deleted.");
}

# script_nucleus_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
sub script_nucleus_check_latest
{
local ($ver) = @_;
local @vers = &osdn_package_versions("nucleuscms", "nucleus([0-9\\.]+)\\.zip");
return "Failed to find versions" if (!@vers);
return $ver eq $vers[0] ? undef : $vers[0];
}

sub script_nucleus_site
{
return 'http://nucleuscms.org/';
}

sub script_nucleus_passmode
{
return 1;
}

1;

