
# script_nms_desc()
sub script_nms_desc
{
return "NMS::FormMail";
}

sub script_nms_uses
{
return ( "perl", "cgi" );
}

sub script_nms_longdesc
{
return "NMS::FormMail is a generic HTML form to e-mail gateway that parses the results of any form and sends them to the specified users. It is a drop-in replacement for the older FormMail program.";
}

# script_nms_versions()
sub script_nms_versions
{
return ( "3.14c1" );
}

sub script_nms_category
{
return "Email";
}

# script_nms_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_nms_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $cdir = &cgi_bin_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install location under <tt>$d->{'home'}</tt>",
		     &ui_textbox("dir", "$cdir/FormMail.pl", 30));
	}
return $rv;
}

# script_nms_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_nms_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation location";
	local $dir = "$d->{'home'}/$in{'dir'}";
	if (-r $dir) {
		return "NMS::FormMail or some other program already exists at the selected location.";
		}
	local $cdir = &cgi_bin_dir($d);
	local $hdir = &public_html_dir($d);
	local $path;
	if ($dir =~ /^\Q$cdir\E\/(.*)$/) {
		# Under /cgi-bin
		$path = "/cgi-bin/$1";
		}
	elsif ($dir =~ /^\Q$hdir\E\/(.*)$/) {
		# Under HTML dir
		$path = "/$1";
		}
	else {
		return "NMS::FormMail must be installed under the <tt>cgi-bin</tt> or <tt>public_html</tt> directories.";
		}
	return { 'dir' => $dir,
		 'path' => $path, };
	}
}

# script_nms_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_nms_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
return undef;
}

# script_nms_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by PHP-Nuke, each of which is a hash ref
# containing a name, filename and URL
sub script_nms_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "formmail_compat-$ver.tar.gz",
	   'url' => "http://nms-cgi.sourceforge.net/formmail_compat-$ver.tar.gz" } );
return @files;
}

sub script_nms_commands
{
return ("tar", "gunzip");
}

# script_nms_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs NMS::FormMail, and returns either 1 and an informational
# message, or 0 and an error
sub script_nms_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
		     $opts->{'dir'}, "formmail_compat-$ver/FormMail.pl", 1);
$err && return (0, "Failed to extract source : $err");
$out = &run_as_domain_user($d, "chmod 755 ".quotemeta($opts->{'dir'}));

# Set referers to this domain only
local $lref = &read_file_lines_as_domain_user($d, $opts->{'dir'});
foreach my $l (@$lref) {
	if ($l =~ /^\s*\@referers\s*=\s*qw/) {
		$l = "  \@referers = qw($d->{'dom'} $d->{'ip'} localhost 127.0.0.1);";
		}
	if ($l =~ /^\s*\@allow_mail_to\s*=\s*qw/) {
		$l = "  \@allow_mail_to = qw($d->{'emailto_addr'});";
		}
	}
&flush_file_lines_as_domain_user($d, $opts->{'dir'});

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "NMS::FormMail can be accessed at <a target=_blank href='$url'>$url</a>.", "At $rp", $url);
}

# script_nms_uninstall(&domain, version, &opts)
# Un-installs a NMS::FormMail installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_nms_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
&is_under_directory($d->{'home'}, $opts->{'dir'}) ||
	return (0, "Invalid install directory $opts->{'dir'}");
local $out = &backquote_logged("rm -rf ".quotemeta($opts->{'dir'}));
$? && return (0, "Failed to delete files : <tt>$out</tt>");

return (1, "NMS::FormMail program deleted.");
}

# script_nms_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_nms_latest
{
return ( "http://nms-cgi.sourceforge.net/scripts.shtml",
	 "formmail_compat-([a-z0-9\\.]+)\\.tar\\.gz" );
}

sub script_nms_site
{
return 'http://nms-cgi.sourceforge.net/';
}

1;

