
# script_mambo_desc()
sub script_mambo_desc
{
return "Mambo";
}

sub script_mambo_disabled
{
return 1;	# Project appears to be dead
}

sub script_mambo_uses
{
return ( "php" );
}

# script_mambo_longdesc()
sub script_mambo_longdesc
{
return "Mambo is a powerful Open Source Content Management System.";
}

# script_mambo_versions()
sub script_mambo_versions
{
return ( "4.6.5" );
}

sub script_mambo_category
{
return "Content Management System";
}

sub script_mambo_php_vers
{
return ( 4 );
}

sub script_mambo_php_modules
{
local ($d, $ver, $phpver, $opts) = @_;
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return $dbtype eq "mysql" ? ("mysql") : ("pgsql");
}

sub script_mambo_dbs
{
local ($d, $ver) = @_;
return ("mysql", "postgres");
}

# script_mambo_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing mambo
sub script_mambo_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Mambo tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql", "postgres" ]);
	$rv .= &ui_table_row("Database for Mambo tables",
		     &ui_database_select("db", undef, \@dbs, $d, "mambo"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("mambo", $d), 30, "At top level"));
	}
return $rv;
}

# script_mambo_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_mambo_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_mambo_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_mambo_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/configuration.php") {
	return "Mambo appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "mos_.*");
$clash && return "Mambo appears to be already using the selected database (table $clash)";
return undef;
}

# script_mambo_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by mambo, each of which is a hash ref
# containing a name, filename and URL
sub script_mambo_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "MamboV$ver.zip",
           'url' => "http://mambo-code.org/gf/download/frsrelease/388/791/MamboV$ver.zip",
	   'virtualmin' => 1,
	   'nocheck' => 1 } );
return @files;
}

sub script_mambo_commands
{
return ("unzip");
}

# script_mambo_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs mambo, and returns either 1 and an informational
# message, or 0 and an error
sub script_mambo_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;

local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, undef);
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/configuration.php";
if (!-r $cfile) {
	local $cdef = "$opts->{'dir'}/configuration.php-dist";
	if (!-r $cdef) {
		$cdef = "$opts->{'dir'}/configuration.sample.php";
		}
	if (!-r $cdef) {
		return (-1, "Failed to find template configuration file");
		}
	&run_as_domain_user($d, "cp ".quotemeta($cdef)." ".quotemeta($cfile),);
	}

# Update database details in config.php
local $url = &script_path_url($d, $opts);
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
        if ($l =~ /^\$mosConfig_host\s*=/) {
		$l = "\$mosConfig_host = \'$dbhost\';";
		}
	if ($l =~ /^\$mosConfig_user\s*=/) {
		$l = "\$mosConfig_user = \'$dbuser\';";
		}
	if ($l =~ /^\$mosConfig_password\s*=/) {
		$l = "\$mosConfig_password = \'".&php_quotemeta($dbpass)."\';";
		}
        if ($l =~ /^\$mosConfig_dbprefix\s*=/) {
		$l = "\$mosConfig_dbprefix = \'mos_\';";
		}
        if ($l =~ /^\$mosConfig_db\s*=/) {
		$l = "\$mosConfig_db = \'$dbname\';";
		}
	if ($l =~ /^\$mosConfig_live_site\s*=/) {
		local $noslash = $url;
		$noslash =~ s/\/$//;
		$l = "\$mosConfig_live_site = \'$noslash\';";
		}
        if ($l =~ /^\$mosConfig_absolute_path\s*=/) {
		local $noslashd = "$opts->{'dir'}/";
		$noslashd =~ s/\/$//;
		$l = "\$mosConfig_absolute_path = \'$noslashd\';";
	        }
       if ($l =~ /^\$mosConfig_cachepath\s*=/) {
		local $noslashdd = "$opts->{'dir'}/cache/";
		$noslashdd =~ s/\/$//;
		$l = "\$mosConfig_cachepath = \'$noslashdd\';";
               }
        }

&flush_file_lines_as_domain_user($d, $cfile);


if (!$upgrade) { 
	# Run the SQL setup script and set the prefix
	if ($dbtype eq "mysql") {
		local $sqlfile = "$opts->{'dir'}/installation/sql/mambo.sql";
		# Load the mambo.sql file data for writting the prefix
		open (FILE, $sqlfile) or die "Cannot open file:$!";
		while ( $line = <FILE>){
			$line=~ s/#_/mos/g;
			push(@outLines, $line);
			}
		close FILE;

		# Load the sample_data.sql file for writting the prefix
        	local $sqldatafile = "$opts->{'dir'}/installation/sql/sample_data.sql";
		# Append the default user data to the sample_data file
		open(DAT,">>$sqldatafile") || die ("Cannot Open File");
		print DAT "INSERT INTO `#__users` VALUES (62, 'Administrator', 'admin', 'your-email\@email.com', '21232f297a57a5a743894a0e4a801fc3', 'Super Administrator', 0, 1, 25, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '');\n";
		print DAT "INSERT INTO `#__core_acl_aro` VALUES (10,'users','62',0,'Administrator',0);\n";
		print DAT "INSERT INTO `#__core_acl_groups_aro_map` VALUES (25,'',10);\n";
		close (DAT);
	# Write the data to sample_data.sql and create the database, tables, and load the data
		open (FILE, $sqldatafile) || die ("Cannot open file:$!");
		while ( $line = <FILE>){
		$line=~ s/#_/mos/g;
		push(@outLines, $line);
		}
		close FILE;
		open ( OUTFILE, ">$sqldatafile" );
		print ( OUTFILE @outLines );
		close ( OUTFILE );
		&require_mysql();
		($ex, $out) = &mysql::execute_sql_file($dbname, $sqldatafile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run sample database setup script : <tt>$out</tt>.");
                }
	elsif ($dbtype eq "postgres") {
		local $sqlfile = "$opts->{'dir'}/installation/sql/mambo.sql";
	# Load the mambo.sql file data for writting the prefix
		open (FILE, $sqlfile) or die "Cannot open file:$!";
		while ( $line = <FILE>){
		$line=~ s/#_/mos/g;
		push(@outLines, $line);
		}
		close FILE;
		&flush_file_lines($line);
	# Load the sample_data.sql file for writting the prefix
        	local $sqldatafile = "$opts->{'dir'}/installation/sql/sample_data.sql";
	# Append the default user data to the sample_data file
		open(DAT,">>$sqldatafile") || die ("Cannot Open File");
		print DAT "INSERT INTO `#__users` VALUES (62, 'Administrator', 'admin', 'your-email\@email.com', '21232f297a57a5a743894a0e4a801fc3', 'Super Administrator', 0, 1, 25, '2005-09-28 00:00:00', '2005-09-28 00:00:00', '', '');\n";
		print DAT "INSERT INTO `#__core_acl_aro` VALUES (10,'users','62',0,'Administrator',0);\n";
		print DAT "INSERT INTO `#__core_acl_groups_aro_map` VALUES (25,'',10);\n";
		close (DAT);
	# Write the data to sample_data.sql and create the database, tables, and load the data
		open (FILE, $sqldatafile) || die ("Cannot open file:$!");
		while ( $line = <FILE>){
		$line=~ s/#_/mos/g;
		push(@outLines, $line);
		}
		close FILE;
		open ( OUTFILE, ">$sqldatafile" );
		print ( OUTFILE @outLines );
		close ( OUTFILE );
		&require_postgres();
		($ex, $out) = &postgres::execute_sql_file($dbname, $sqldatafile, $dbuser, $dbpass);
		$ex && return (0, "Failed to run sample database setup script : <tt>$out</tt>.");
                }
	}

# Remove the installation directory and files.
local $minstallation = "$opts->{'dir'}/installation";
$minstallation  =~ s/\/$//;
&run_as_domain_user($d, "rm -rf ".quotemeta($minstallation )."/* ");
&run_as_domain_user($d, "rmdir ".quotemeta($minstallation ));
 
# Set write permissions on directories and the configuration.php file
local $dcr = "$opts->{'dir'}";
$dca = "$opts->{'dir'}/administrator";
&make_file_php_writable($d, "$dcr/images");
&make_file_php_writable($d, "$dcr/mambots");
foreach my $f ("$dca/backups", "$dca/components", "$dca/modules",
	       "$dca/templates", "$dcr/cache", "$dcr/components",
	       "$dcr/language", "$dcr/media", "$dcr/modules", "$dcr/templates",
	       "$dcr/configuration.php") {
	&make_file_php_writable($d, $f, 1);
	}

# Return a URL for the user
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Mambo installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>.", "Under $rp", $url, "admin", "admin");
}

# script_mambo_uninstall(&domain, version, &opts)
# Un-installs a mambo installation, by deleting the directory.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_mambo_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all mos_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "mos_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "Mambo directory and tables deleted.");
}

# script_mambo_latest()
# Returns a URL and regular expression or callback func to get the version
# Disabled, as no new versions seem to be coming out
#sub script_mambo_latest
#{
#return ( "http://mambo-code.org/gf/project/mambo/frs/?action=&_br_pkgrls_total=50&_br_pkgrls_page=2",
#	 "MamboV([0-9\\.]+)\\.tar\\.gz" );
#}

sub script_mambo_site
{
return 'http://www.mamboserver.com/';
}

1;

