
@magento_sample_tables = (
	"admin_assert",
        "admin_role",
        "admin_rule",
        "admin_user",
        "adminnotification_inbox",
        "api_assert",
        "api_role",
        "api_rule",
        "api_session",
        "api_user",
        "catalog_category_entity",
        "catalog_category_entity_datetime",
        "catalog_category_entity_decimal",
        "catalog_category_entity_int",
        "catalog_category_entity_text",
        "catalog_category_entity_varchar",
        "catalog_category_product",
        "catalog_category_product_index",
	"catalog_category_anc_categs_index_idx",
	"catalog_category_anc_categs_index_tmp",
	"catalog_category_anc_products_index_idx",
	"catalog_category_anc_products_index_tmp",
	"catalog_category_product_index_enbl_idx",
	"catalog_category_product_index_enbl_tmp",
	"catalog_category_product_index_idx",
	"catalog_category_product_index_tmp",
	"catalog_product_index_eav_decimal_idx",
	"catalog_product_index_eav_decimal_tmp",
	"catalog_product_index_eav_idx",
	"catalog_product_index_eav_tmp",
	"catalog_product_index_price_cfg_opt_agr_idx",
	"catalog_product_index_price_cfg_opt_agr_tmp",
	"catalog_product_index_price_cfg_opt_idx",
	"catalog_product_index_price_cfg_opt_tmp",
	"catalog_product_index_price_final_idx",
	"catalog_product_index_price_final_tmp",
	"catalog_product_index_price_idx",
	"catalog_product_index_price_opt_agr_idx",
	"catalog_product_index_price_opt_agr_tmp",
	"catalog_product_index_price_opt_idx",
	"catalog_product_index_price_opt_tmp",
	"catalog_product_index_price_tmp",
	"core_resource",
	"core_website",
	"customer_eav_attribute_website",
	"customer_form_attribute",
	"eav_attribute",
	"eav_entity_type",
        "catalog_compare_item",
        "catalog_eav_attribute",
        "catalog_product_bundle_option",
        "catalog_product_bundle_option_value",
        "catalog_product_bundle_price_index",
        "catalog_product_bundle_selection",
        "catalog_product_bundle_stock_index",
        "catalog_product_enabled_index",
        "catalog_product_entity",
        "catalog_product_entity_datetime",
        "catalog_product_entity_decimal",
        "catalog_product_entity_gallery",
        "catalog_product_entity_int",
        "catalog_product_entity_media_gallery",
        "catalog_product_entity_media_gallery_value",
        "catalog_product_entity_text",
        "catalog_product_entity_tier_price",
        "catalog_product_entity_varchar",
        "catalog_product_index_eav",
        "catalog_product_index_eav_decimal",
        "catalog_product_index_price",
        "catalog_product_index_tier_price",
        "catalog_product_index_website",
        "catalog_product_link",
        "catalog_product_link_attribute",
        "catalog_product_link_attribute_decimal",
        "catalog_product_link_attribute_int",
        "catalog_product_link_attribute_varchar",
        "catalog_product_link_type",
        "catalog_product_option",
        "catalog_product_option_price",
        "catalog_product_option_title",
        "catalog_product_option_type_price",
        "catalog_product_option_type_title",
        "catalog_product_option_type_value",
        "catalog_product_relation",
        "catalog_product_super_attribute",
        "catalog_product_super_attribute_label",
        "catalog_product_super_attribute_pricing",
        "catalog_product_super_link",
        "catalog_product_website",
        "catalogindex_aggregation",
        "catalogindex_aggregation_tag",
        "catalogindex_aggregation_to_tag",
        "catalogindex_eav",
        "catalogindex_minimal_price",
        "catalogindex_price",
        "cataloginventory_stock",
        "cataloginventory_stock_item",
        "cataloginventory_stock_status",
        "catalogrule",
        "catalogrule_affected_product",
        "catalogrule_group_website",
        "catalogrule_product",
        "catalogrule_product_price",
        "catalogsearch_fulltext",
        "catalogsearch_query",
        "catalogsearch_result",
        "checkout_agreement",
        "checkout_agreement_store",
        "chronopay_api_debug",
        "cms_block",
        "cms_block_store",
        "cms_page",
        "cms_page_store",
        "core_cache",
        "core_cache_option",
        "core_cache_tag",
        "core_config_data",
        "core_email_template",
        "core_flag",
        "core_layout_link",
        "core_layout_update",
        "core_resource",
        "core_session",
        "core_store",
        "core_store_group",
        "core_translate",
        "core_url_rewrite",
        "core_variable",
        "core_variable_value",
        "core_website",
        "coupon_aggregated",
        "coupon_aggregated_order",
        "cron_schedule",
        "customer_address_entity",
        "customer_address_entity_datetime",
        "customer_address_entity_decimal",
        "customer_address_entity_int",
        "customer_address_entity_text",
        "customer_address_entity_varchar",
        "customer_eav_attribute",
        "customer_entity",
        "customer_entity_datetime",
        "customer_entity_decimal",
        "customer_entity_int",
        "customer_entity_text",
        "customer_entity_varchar",
        "customer_group",
        "cybermut_api_debug",
        "cybersource_api_debug",
        "dataflow_batch",
        "dataflow_batch_export",
        "dataflow_batch_import",
        "dataflow_import_data",
        "dataflow_profile",
        "dataflow_profile_history",
        "dataflow_session",
        "design_change",
        "directory_country",
        "directory_country_format",
        "directory_country_region",
        "directory_country_region_name",
        "directory_currency_rate",
        "downloadable_link",
        "downloadable_link_price",
        "downloadable_link_purchased",
        "downloadable_link_purchased_item",
        "downloadable_link_title",
        "downloadable_sample",
        "downloadable_sample_title",
        "eav_attribute",
        "eav_attribute_group",
        "eav_attribute_label",
        "eav_attribute_option",
        "eav_attribute_option_value",
        "eav_attribute_set",
        "eav_entity",
        "eav_entity_attribute",
        "eav_entity_datetime",
        "eav_entity_decimal",
        "eav_entity_int",
        "eav_entity_store",
        "eav_entity_text",
        "eav_entity_type",
        "eav_entity_varchar",
        "eav_form_element",
        "eav_form_fieldset",
        "eav_form_fieldset_label",
        "eav_form_type",
        "eav_form_type_entity",
        "eway_api_debug",
        "flo2cash_api_debug",
        "gift_message",
        "googlebase_attributes",
        "googlebase_items",
        "googlebase_types",
        "googlecheckout_api_debug",
        "googleoptimizer_code",
        "ideal_api_debug",
        "index_event",
        "index_process",
        "index_process_event",
        "log_customer",
        "log_quote",
        "log_summary",
        "log_summary_type",
        "log_url",
        "log_url_info",
        "log_visitor",
        "log_visitor_info",
        "log_visitor_online",
        "newsletter_problem",
        "newsletter_queue",
        "newsletter_queue_link",
        "newsletter_queue_store_link",
        "newsletter_subscriber",
        "newsletter_template",
        "oscommerce_import",
        "oscommerce_import_type",
        "oscommerce_orders",
        "oscommerce_orders_products",
        "oscommerce_orders_status_history",
        "oscommerce_orders_total",
        "oscommerce_ref",
        "paybox_api_debug",
        "paybox_question_number",
        "paygate_authorizenet_debug",
        "paypal_api_debug",
        "paypaluk_api_debug",
        "poll",
        "poll_answer",
        "poll_store",
        "poll_vote",
        "product_alert_price",
        "product_alert_stock",
        "protx_api_debug",
        "rating",
        "rating_entity",
        "rating_option",
        "rating_option_vote",
        "rating_option_vote_aggregated",
        "rating_store",
        "rating_title",
        "report_compared_product_index",
        "report_event",
        "report_event_types",
        "report_viewed_product_index",
        "review",
        "review_detail",
        "review_entity",
        "review_entity_summary",
        "review_status",
        "review_store",
        "sales_flat_order_item",
        "sales_flat_quote",
        "sales_flat_quote_address",
        "sales_flat_quote_address_item",
        "sales_flat_quote_item",
        "sales_flat_quote_item_option",
        "sales_flat_quote_payment",
        "sales_flat_quote_shipping_rate",
        "sales_invoiced_aggregated",
        "sales_invoiced_aggregated_order",
        "sales_order",
        "sales_order_aggregated_created",
        "sales_order_datetime",
        "sales_order_decimal",
        "sales_order_entity",
        "sales_order_entity_datetime",
        "sales_order_entity_decimal",
        "sales_order_entity_int",
        "sales_order_entity_text",
        "sales_order_entity_varchar",
        "sales_order_int",
        "sales_order_tax",
        "sales_order_text",
        "sales_order_varchar",
        "sales_payment_transaction",
        "sales_refunded_aggregated",
        "sales_refunded_aggregated_order",
        "sales_shipping_aggregated",
        "sales_shipping_aggregated_order",
        "salesrule",
        "salesrule_customer",
        "salesrule_label",
        "sendfriend_log",
        "shipping_tablerate",
        "sitemap",
        "strikeiron_tax_rate",
        "tag",
        "tag_relation",
        "tag_summary",
        "tax_calculation",
        "tax_calculation_rate",
        "tax_calculation_rate_title",
        "tax_calculation_rule",
        "tax_class",
        "tax_order_aggregated_created",
        "weee_discount",
        "weee_tax",
        "widget",
        "widget_instance",
        "widget_instance_page",
        "widget_instance_page_layout",
        "wishlist",
        "wishlist_item" );

# script_magento_desc()
sub script_magento_desc
{
return "Magento";
}

sub script_magento_uses
{
return ( "php" );
}

sub script_magento_longdesc
{
return "Magento is a new professional open-source eCommerce solution offering unprecedented flexibility and control.";
}

# script_magento_versions()
sub script_magento_versions
{
return ( "1.8.1.0" );
}

sub script_magento_can_upgrade
{
local ($sinfo, $newver) = @_;
if ($newver >= 1.6 && $sinfo->{'version'} < 1.6) {
	# Cannot upgrade 1.5 to 1.6
	return 0;
	}
return 1;
}

sub script_magento_category
{
return "Commerce";
}

sub script_magento_php_vers
{
return ( 5 );
}

sub script_magento_php_modules
{
return ( "mysql", "mcrypt", "xml", "curl", "pdo_mysql" );
}

sub script_magento_dbs
{
return ("mysql");
}

# script_magento_depends(&domain, version)
sub script_magento_depends
{
local ($d, $ver, $sinfo, $phpver) = @_;
local @rv;

# Check for PHP 5.2+
local $phpv = &get_php_version($phpver || 5, $d);
if (!$phpv) {
	push(@rv, "Could not work out exact PHP version");
	}
elsif ($phpv < 5.2) {
	push(@rv, "Magento requires PHP version 5.2 or later");
	}

# Check for MySQL 4.1.20+
&require_mysql();
local $myver = &mysql::get_mysql_version();
if (&compare_versions($myver, "4.1.20") < 0) {
	push(@rv, "Magento requires MySQL version 4.1.20 or later");
	}

return @rv;
}

# script_magento_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Magento
sub script_magento_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Magento tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Magento tables",
		     &ui_database_select("db", undef, \@dbs, $d, "magento"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("magento", $d), 30, "At top level"));
	$rv .= &ui_table_row("Install sample data?",
			     &ui_yesno_radio("sample", 0));
	}
return $rv;
}

# script_magento_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_magento_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
	         'dir' => $dir,
		 'sample' => $in->{'sample'},
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_magento_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_magento_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "Magento appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "magento_");
$clash && return "Magento appears to be already using the selected database (table $clash)";
return undef;
}

# script_magento_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Magento, each of which is a hash ref
# containing a name, filename and URL
sub script_magento_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "magento-$ver.zip",
	   'url' => "http://www.magentocommerce.com/downloads/assets/$ver/magento-$ver.tar.gz" });
if ($opts->{'sample'} && !$upgrade) {
	push(@files, { 'name' => 'sample',
		       'file' => "magento-sample-data-$ver.zip",
		       'referer' => "http://www.magentocommerce.com/download/get-started",
		       'url' => "http://www.magentocommerce.com/getmagento/1.2.0/magento-sample-data-1.2.0.zip",
		     });
	}
return @files;
}

sub script_magento_commands
{
return ("unzip");
}

# script_magento_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Magento, and returns either 1 and an informational
# message, or 0 and an error
sub script_magento_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);

if ($opts->{'newdb'} && !$upgrade) {
	local $err = &create_script_database($d, $opts->{'db'});
	return (0, "Database creation failed : $err") if ($err);
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "magento");
$err && return (0, "Failed to extract source : $err");

# Extract sample data and copy to target
local $sampletemp = &transname();
if ($opts->{'sample'} && !$upgrade) {
	local $err = &extract_script_archive($files->{'sample'}, $sampletemp,
			     $d, $opts->{'dir'}, "magento-sample-data-*");
	$err && return (0, "Failed to extract sample data : $err");
	}

# Run sample SQL
if ($opts->{'sample'} && !$upgrade) {
	local $sqlfile = "$sampletemp/magento-sample-data-1.2.0/magento_sample_data_for_1.2.0.sql";
	my ($ex, $out) = &mysql::execute_sql_file(
				$dbname, $sqlfile, $dbuser, $dbpass);
	$ex && return (-1, "Failed to run sample data SQL : <tt>$out</tt>");
	}

# Make needed directories writable
&make_file_php_writable($d, "$opts->{'dir'}/var/.htaccess");
&make_file_php_writable($d, "$opts->{'dir'}/app/etc", 1);
&make_file_php_writable($d, "$opts->{'dir'}/var", 1);
&make_file_php_writable($d, "$opts->{'dir'}/media");

local $url = &script_path_url($d, $opts);
local $longpass = $dompass;

if (!$upgrade) {
	# Build the command line to call Magento's install script
	local ($p5) = grep { $_->[0] == $opts->{'phpver'} }
			   &list_available_php_versions($d);
	local $cmd = $p5->[1];
	if (!$cmd) {
		$cmd = &has_command("php5") ||
		       &has_command("php");
		}
	$cmd =~ s/-cgi$//;
	$cmd .= " -f ".$opts->{'dir'}."/install.php --";
	$cmd .= " --license_agreement_accepted yes";
	$cmd .= " --locale en_US";
	$cmd .= " --timezone America/Los_Angeles";
	$cmd .= " --default_currency USD";
	$cmd .= " --db_host ".quotemeta($dbhost);
	$cmd .= " --db_name ".quotemeta($dbname);
	$cmd .= " --db_user ".quotemeta($dbuser);
	$cmd .= " --db_pass ".quotemeta($dbpass);
	if (!$opts->{'sample'}) {
		$cmd .= " --db_prefix magento_";
		}
	$cmd .= " --url ".quotemeta($url);
	$cmd .= " --skip_url_validation";
	if (length($longpass) < 6 || $longpass !~ /[0-9]/) {
		$longpass .= "123456";
		}
	local ($firstname, $lastname) = split(/\s+/, $d->{'owner'});
	$cmd .= " --admin_firstname ".quotemeta($firstname || "none");
	$cmd .= " --admin_lastname ".quotemeta($lastname || "none");
	$cmd .= " --admin_email ".quotemeta($d->{'emailto_addr'});
	$cmd .= " --admin_username ".quotemeta($domuser);
	$cmd .= " --admin_password ".quotemeta($longpass);
	$opts->{'enckey'} = &random_password(16);
	$cmd .= " --encryption_key ".quotemeta($opts->{'enckey'});
	$cmd .= " --use_secure no";
	if ($d->{'ssl'}) {
		local $securl = $url;
		$securl =~ s/^http:/https:/;
		$cmd .= " --secure_base_url ".quotemeta($securl);
		$cmd .= " --use_secure_admin yes";
		}
	else {
		$cmd .= " --secure_base_url ".quotemeta($url);
		$cmd .= " --use_secure_admin no";
		}
	local $p = &domain_has_website($d);
	if ($p eq 'web') {
		&require_apache();
		if ($apache::httpd_modules{'mod_rewrite'}) {
			$cmd .= " --use_rewrites yes";
			}
		}
	local $phpver = $opts->{'phpver'} || 5;
	if (-d "$d->{'home'}/etc/php$phpver") {
		$cmd = "PHPRC=$d->{'home'}/etc/php$phpver $cmd";
		}

	# Run it as the domain owner
	local $out = &run_as_domain_user($d,
		"cd ".quotemeta($opts->{'dir'})." && ".$cmd." 2>&1");
	if ($? || $out =~ /FAILED/) {
		# Try again.. this is needed for Magento 1.3.2
		$out = &run_as_domain_user($d,
			"cd ".quotemeta($opts->{'dir'})." && ".$cmd." 2>&1");
		}
	if ($? || $out =~ /FAILED/) {
		return (-1, "Installation script failed : <pre>".
			    &html_escape($out)."</pre>");
		}
	}
else {
	# Clear out the cache and session directories, as these objects are
	# not valid for new versions
	&run_as_domain_user($d,
		"rm -rf ".quotemeta("$opts->{'dir'}/var/cache")."/*");
	&run_as_domain_user($d,
		"rm -rf ".quotemeta("$opts->{'dir'}/var/session")."/*");
	}

# Tell the user about the new install
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."index.php/admin/";
return (1, "Initial Magento installation complete. Go to <a target=_blank href='$adminurl'>$adminurl</a> to manage it.", "Under $rp using MySQL database $dbname", $url, $domuser, $longpass );
}

# script_magento_uninstall(&domain, version, &opts)
# Un-installs a Magento installation, by removing it's files
# Returns 1 on success and a message, or 0 on failure and an error
sub script_magento_uninstall
{
local ($d, $version, $opts) = @_;

# Remove magento tables from the database
local $tries = 0;
while(1) {
	local $err = &cleanup_script_database($d, $opts->{'db'},
		$opts->{'sample'} ? \@magento_sample_tables : "magento_");
	last if (!$err || $err =~ /Unknown\s+database/i);
	if ($tries++ > 1000) {
		return (0, "Failed to delete all Magento tables ".
			   "after 1000 attempts : $err");
		}
	}

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Take out the DB
if ($opts->{'newdb'}) {
	&delete_script_database($d, $opts->{'db'});
	}

return (1, "Deleted Magento directory and tables.");
}

# script_magento_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_magento_latest
{
local ($ver) = @_;
return ( "http://www.magentocommerce.com/download/noregister",
	 "magento-(1\\.[0-9]\\.[0-79\\.]+)\\.zip" );
}

sub script_magento_site
{
return 'http://www.magentocommerce.com/';
}

sub script_magento_passmode
{
return 1;
}

1;

