
# script_instiki_desc()
sub script_instiki_desc
{
return "Instiki";
}

sub script_instiki_uses
{
return ( "ruby", "proxy" );
}

sub script_instiki_longdesc
{
return "Instiki is a wiki clone with strong focus on ease of installation and running.";
}

# script_instiki_versions()
sub script_instiki_versions
{
return ( "0.19.6" );
}

sub script_instiki_category
{
return "Wiki";
}

sub script_instiki_gems
{
return ( defined(&get_ruby_rails_gems) ? &get_ruby_rails_gems() : ( ),
	 [ "mongrel", undef, 1 ],
	 [ "sqlite3-ruby", undef, 1 ] );
}

# script_instiki_depends(&domain, version)
# Check for ruby command, ruby gems, mod_proxy
sub script_instiki_depends
{
local ($d, $ver) = @_;
local @rv;
&has_command("ruby") || push(@rv, "The ruby command is not installed");
&require_apache();
&has_proxy_balancer($d) ||
	push(@rv, "The Apache proxy module is not installed");
my $ver = &get_ruby_version();
&compare_versions($ver, "1.8.7") >= 0 ||
	push(@rv, "Instiki requires Ruby version 1.8.7 or later, ".
		  "but your system has only version $ver");
return @rv;
}

# script_instiki_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_instiki_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("instiki", $d), 30, "At top level"));
	$rv .= &show_mongrels_ports_input($d);
	}
return $rv;
}

# script_instiki_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_instiki_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in->{'dir_def'} || $in->{'dir'} =~ /\S/ && $in->{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in->{'dir_def'} ? $hdir : "$hdir/$in->{'dir'}";
	local $mongrels = &parse_mongrels_ports_input($d, $in);
	return $mongrels if (!int($mongrels));
	return { 'dir' => $dir,
		 'path' => $in->{'dir_def'} ? "/" : "/$in->{'dir'}",
		 'mongrels' => $mongrels,
	       };
	}
}

# script_instiki_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_instiki_check
{
local ($d, $ver, $opts, $upgrade) = @_;
if (-r "$opts->{'dir'}/instiki") {
	return "Instiki appears to be already installed in the selected directory";
	}
$opts->{'mongrels'} ||= 1;
return undef;
}

# script_instiki_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Instiki, each of which is a hash ref
# containing a name, filename and URL
sub script_instiki_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "instiki-$ver.zip",
	   'url' => "http://rubyforge.org/frs/download.php/76756/instiki-$ver.zip" } );
}

sub script_instiki_commands
{
return ("unzip");
}

sub script_instiki_packages
{
return &get_ruby_rails_packages();
}

# script_instiki_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Instiki, and returns either 1 and an informational
# message, or 0 and an error
sub script_instiki_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Check for mongrel
if (!&find_rails_command("mongrel_rails")) {
	return (0, "The mongrel_rails command was not found");
	}

if ($upgrade) {
	# Stop the running instiki server
	&script_instiki_stop_server($d, $opts);
	}

# Copy db directory to a temp location when upgrading
local $dbtemp;
if ($upgrade) {
	$dbtemp = &transname();
	&copy_source_dest("$opts->{'dir'}/db", $dbtemp);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "*instiki*");
$err && return (0, "Failed to extract source : $err");

if (!$upgrade) {
	# Find a free port
	$opts->{'port'} = &allocate_mongrel_port(undef, $opts->{'mongrels'});
	}

# Put back the db directory
if ($upgrade) {
	&copy_source_dest_as_domain_user($d, $dbtemp, "$opts->{'dir'}/db");
	}

# Create fix for Rails 2.3 bug
&create_mongrel_prefix_bugfix($d, $opts);

# Install bundle of gems
my $out = &run_as_domain_user($d, "cd $opts->{'dir'} && ./bundle install 2>&1");
if ($?) {
	return (-1, "Bundle install failed : <pre>".&html_escape($out)."</pre>");
	}

# Start the servers
local (@logs, @startcmds, @stopcmds);
local @ports = split(/\s+/, $opts->{'port'});
local $err = &mongrel_rails_start_servers($d, $opts, "instiki", \@startcmds,
					  \@stopcmds, \@logs,
					  "$opts->{'dir'}/instiki");
return (0, $err) if ($err);
$opts->{'log'} = join(" ", @logs);

# Setup an Apache proxy for it
&setup_mongrel_proxy($d, $opts->{'path'}, $opts->{'port'},
		     $opts->{'path'} eq '/' ? undef : $opts->{'path'});

if (!$upgrade) {
	# Configure server to start at boot
	local $stopcmd = "fuser -k ".quotemeta($log);
	&setup_mongrel_startup($d,
			       join("\n", @startcmds),
			       join("\n", @stopcmds),
			       $opts,
			       1, "instiki-".$ports[0], "Instiki Wiki");
	}

if (!$upgrade) {
	# Deny regular web access to directory
	&protect_rails_directory($d, $opts);
	}

local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Initial Instiki installation complete. Go to <a target=_blank href='$url'>$url</a> to create your first Wiki.", "Under $rp", $url);
}

# script_instiki_uninstall(&domain, version, &opts)
# Un-installs a Instiki installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_instiki_uninstall
{
local ($d, $version, $opts) = @_;

# Shut down the server process
&script_instiki_stop_server($d, $opts);

# Remove bootup script
&delete_mongrel_startup($d, $opts, "instiki", $opts->{'port'});

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove proxy Apache config entry for /instiki
&delete_mongrel_proxy($d, $opts->{'path'});

return (1, "Instiki directory deleted.");
}

# script_instiki_stop(&domain, &sinfo)
# Stop running mongrel process
sub script_instiki_stop
{
local ($d, $sinfo) = @_;
&script_instiki_stop_server($d, $sinfo->{'opts'}, "instiki");
&delete_mongrel_startup($d, $sinfo->{'opts'},
			"instiki", $sinfo->{'opts'}->{'port'});
}

sub script_instiki_latest
{
return ( "http://rubyforge.org/frs/?group_id=186",
         "instiki-([0-9\\.]+)\\.zip" );
}

sub script_instiki_start_server
{
local ($d, $opts) = @_;
return &mongrel_rails_start_servers($d, $opts, "instiki", undef, undef,
				    undef, "$opts->{'dir'}/instiki");
}

sub script_instiki_status_server
{
local ($d, $opts) = @_;
return &mongrel_rails_status_servers($d, $opts, "instiki");
}

# script_instiki_stop_server(&domain, &opts)
# Stop an instiki webserver
sub script_instiki_stop_server
{
local ($d, $opts) = @_;
&mongrel_rails_stop_servers($d, $opts, "instiki");
}

sub script_instiki_site
{
return 'http://www.instiki.org/';
}

1;

