
# script_idreams_desc()
sub script_idreams_desc
{
return "i-dreams.net Guestbook";
}

sub script_idreams_uses
{
return ( "perl", "cgi" );
}

sub script_idreams_longdesc
{
return "Firebook is a free guestbook software, which can be easily installed for your own homepage, and which will run stable, secure and efficiently.";
}

# script_idreams_versions()
sub script_idreams_versions
{
return ( "6.0" );
}

sub script_idreams_abandoned
{
return 2;
}

sub script_idreams_category
{
return "Guestbook";
}

# script_idreams_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_idreams_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $cdir = &cgi_bin_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	$rv .= &ui_table_row("Install sub-directory under <tt>$cdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("firebook", $d), 30, "At top level"));
	}
return $rv;
}

# script_idreams_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_idreams_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $cdir = &cgi_bin_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $cdir : "$cdir/$in{'dir'}";
	return { 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_idreams_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_idreams_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/firebook.cgi") {
	return "i-dreams.net Guestbook appears to be already installed in the selected directory";
	}
return undef;
}

# script_idreams_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_idreams_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "idreams_gb$ver.zip",
           'nocheck' => 1,
	   'virtualmin' => 1,
	   'url' => "http://www.firebook.de/sites/default/files/firebook_$ver.zip" } );
return @files;
}

sub script_idreams_commands
{
return ("unzip");
}

# script_idreams_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs i-dreams.net Guestbook, and returns either 1 and an informational
# message, or 0 and an error
sub script_idreams_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
		     $opts->{'dir'}, "firebook_$ver/script/cgi-bin/firebook");
$err && return (0, "Failed to extract source : $err");
local $cgi = "$opts->{'dir'}/firebook.cgi";

# Remove DOS newlines
opendir(DIR, $opts->{'dir'});
foreach my $c (readdir(DIR)) {
	if ($c =~ /\.(cgi|pl)$/i) {
		local $lref = &read_file_lines_as_domain_user(
				$d, "$opts->{'dir'}/$c");
		&flush_file_lines_as_domain_user($d, "$opts->{'dir'}/$c", "\n");
		}
	}
closedir(DIR);

# Copy graphics directory
local $hdir = &public_html_dir($d);
$out = &run_as_domain_user($d, "cp -rp ".quotemeta($temp)."/idreams_gb$ver/script/gbgraphx ".quotemeta($hdir));

# Set permissions
&run_as_domain_user($d, "chmod 755 ".quotemeta($opts->{'dir'})." ".
				     quotemeta($opts->{'dir'})."/*.cgi");
&make_file_php_writable($d, "$opts->{'dir'}/config.pl");
&make_file_php_writable($d, "$opts->{'dir'}/data");
&make_file_php_writable($d, "$hdir/gbgraphx");

# Return a URL for the user
local $pt = $d->{'web_port'} == 80 ? "" : ":$d->{'web_port'}";
local $url = "http://$d->{'dom'}$pt/cgi-bin$opts->{'path'}/setup.cgi";
local $userurl = "http://$d->{'dom'}$pt/cgi-bin$opts->{'path'}/firebook.cgi";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "i-dreams.net Guestbook installation complete. It can be configured at <a target=_blank href='$url'>$url</a>.", "Under $rp", $userurl);
}

# script_idreams_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_idreams_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "i-dreams.net Guestbook directory deleted.");
}

sub script_idreams_abandoned
{
return 1;
}

1;

