
# script_gollem_desc()
sub script_gollem_desc
{
return "Gollem";
}

sub script_gollem_uses
{
return ( "php", "horde" );
}

sub script_gollem_longdesc
{
return "Gollem is a web-based file manager, which is part of the Horde project.";
}

# script_gollem_versions()
sub script_gollem_versions
{
return ( "h3-1.1.2" );
}

sub script_gollem_category
{
return "Horde";
}

# script_gollem_depends(&domain, version)
sub script_gollem_depends
{
local ($d, $ver) = @_;

# Check for horde install
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
return ("Gollem requires that Horde be installed first") if (!$horde);

return ( );
}

# script_gollem_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_gollem_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
if ($upgrade) {
	# Options are fixed when upgrading
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
        local $odir = $horde->{'opts'}->{'dir'};
        $odir =~ s/^\Q$d->{'home'}\E\///;
	$rv .= &ui_table_row("Install sub-directory under <tt>$odir</tt>",
			     &ui_textbox("dir", "gollem", 30));
	}
return $rv;
}

# script_gollem_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_gollem_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local @scripts = &list_domain_scripts($d);
	local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;
	$in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = "$horde->{'opts'}->{'dir'}/$in{'dir'}";
	$dir =~ s/\/\//\//g;
        local $path = "$horde->{'opts'}->{'path'}/$in{'dir'}";
        $path =~ s/\/\//\//g;
	return { 'dir' => $dir,
		 'path' => $path,
		 'horde' => 1 };
	}
}

# script_gollem_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_gollem_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
if (-r "$opts->{'dir'}/index.php") {
	return "Gollem appears to be already installed in the selected directory";
	}
return undef;
}

# script_gollem_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Gollem, each of which is a hash ref
# containing a name, filename and URL
sub script_gollem_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "gollem-$ver.tar.gz",
	   'url' => "ftp://ftp.horde.org/pub/gollem/gollem-$ver.tar.gz" } );
return @files;
}

sub script_gollem_commands
{
return ("tar", "gunzip");
}

# script_gollem_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Gollem, and returns either 1 and an informational
# message, or 0 and an error
sub script_gollem_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
local @scripts = &list_domain_scripts($d);
local ($horde) = grep { $_->{'name'} eq 'horde' } @scripts;

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "gollem-$ver");
$err && return (0, "Failed to extract source : $err");

# Copy the config files
local $cdir = "$opts->{'dir'}/config";
opendir(DIR, $cdir);
foreach my $f (readdir(DIR)) {
	if ($f =~ /^(.*)\.dist$/ && !-r "$cdir/$1") {
		&run_as_domain_user($d, "cp ".quotemeta("$cdir/$f")." ".
					      quotemeta("$cdir/$1"));
		&make_file_php_writable($d, "$cdir/$1");
		}
	}
closedir(DIR);
&make_file_php_writable($d, $cdir, 1);

# Insert an SQL backend
if (!$upgrade) {
	local $lref = &read_file_lines_as_domain_user($d, "$cdir/backends.php");
	splice(@$lref, 1, 0,
		"\$backends['virtualmin'] = array(",
		"    'name' => 'Database',",
		"    'driver' => 'sql',",
		"    'preferred' => '',",
		"    'hordeauth' => false,",
		"    'params' => array_merge(\$GLOBALS['conf']['sql'], array('table' => 'horde_vfs')),",
		"    'loginparams' => array(),",
		"    'attributes' => array('type', 'name', 'download', 'modified', 'size', 'permission', 'owner', 'group')",
		");");
	&flush_file_lines_as_domain_user($d, "$cdir/backends.php");
	}

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "Gollem installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>. However, it must first be configured using Horde at <a target=_blank href='$horde->{'url'}'>$horde->{'url'}</a>, on the Setup page under Administration.", "Under $rp", $url);
}

# script_gollem_uninstall(&domain, version, &opts)
# Un-installs a Gollem installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_gollem_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

return (1, "Gollem directory deleted.");
}

# script_gollem_latest()
# Returns a URL and regular expression or callback func to get the version
sub script_gollem_latest
{
return ( "http://ftp.horde.org/pub/gollem/",
         "gollem-(h3-[0-9\\.]+)\\.tar\\.gz" );
}

sub script_gollem_site
{
return 'http://www.horde.org/gollem/';
}

1;

