
# script_dadabik_desc()
sub script_dadabik_desc
{
return "DaDaBIK";
}

sub script_dadabik_uses
{
return ( "php" );
}

sub script_dadabik_longdesc
{
return " DaDaBIK is a free PHP application that allows you to easily create a highly customizable front-end for a database in order to search, insert, update and delete records";
}

# script_dadabik_versions()
sub script_dadabik_versions
{
return ( "4.3" );
}

sub script_dadabik_category
{
return "Database";
}

sub script_dadabik_php_vers
{
return ( 5 );
}

sub script_dadabik_php_modules
{
return ("mysql");
}

sub script_dadabik_dbs
{
return ("mysql");
}

# script_dadabik_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing PHP-NUKE
sub script_dadabik_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for DaDaBIK tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for DaDaBIK tables",
		     &ui_database_select("db", undef, \@dbs));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("dadabik", $d), 30, "At top level"));
	}
return $rv;
}

# script_dadabik_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_dadabik_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_dadabik_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_dadabik_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/include/config.php") {
	return "DaDaBIK appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
return undef;
}

# script_dadabik_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by DaDaBIK, each of which is a hash ref
# containing a name, filename and URL
sub script_dadabik_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "databik_$ver.zip",
	   'virtualmin' => 1,
	   'nocheck' => 1,
	   'url' => "http://prdownloads.sourceforge.net/dadabik/dadabik_$ver.zip" } );
return @files;
}

sub script_dadabik_commands
{
return ("unzip");
}

# script_dadabik_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs DaDaBIK, and returns either 1 and an informational
# message, or 0 and an error
sub script_dadabik_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = $dbtype eq "mysql" ? &mysql_user($d) : &postgres_user($d);
local $dbpass = $dbtype eq "mysql" ? &mysql_pass($d) : &postgres_pass($d, 1);
local $dbphptype = $dbtype eq "mysql" ? "MySQL" : "PostgreSQL";
local $dbhost = &get_database_host($dbtype);
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
			     $opts->{'dir'}, "dadabik_$ver/program_files");
$err && return (0, "Failed to extract source : $err");
local $cfile = "$opts->{'dir'}/include/config.php";

# Update database details in config.php
local $url = &script_path_url($d, $opts);
local $lref = &read_file_lines_as_domain_user($d, $cfile);
local $l;
foreach $l (@$lref) {
	if ($l =~ /^\$host\s*=/) {
		$l = "\$host = \"$dbhost\";";
		}
	if ($l =~ /^\$db_name\s*=/) {
		$l = "\$db_name = \"$dbname\";";
		}
	if ($l =~ /^\$user\s*=/) {
		$l = "\$user = \"$dbuser\";";
		}
	if ($l =~ /^\$pass\s*=/) {
		$l = "\$pass = \"".&php_quotemeta($dbpass)."\";";
		}
	if ($l =~ /^\$site_url\s*=/) {
		$l = "\$site_url = \"$url\";";
		}
	if ($l =~ /^\$site_path\s*=/) {
		$l = "\$site_path = \"$opts->{'dir'}\";";
		}
	if ($l =~ /^\$dbms_type\s*=/) {
		# Only in version 4.0_beta_2
		$l = "\$dbms_type = \"mysql\";";
		}
	}
&flush_file_lines_as_domain_user($d, $cfile);

# Create an example table, if the DB has none
&require_mysql();
local @tables = &mysql::list_tables($dbname);
if (!@tables) {
	eval {
		local $main::error_must_die = 1;
		&mysql::execute_sql($dbname,
			"create table example (id int(4) primary key not null, name varchar(32))");
		};
	if ($@) {
		return (-1, "Example table creation failed : $@");
		}
	$opts->{'created_example'} = 1;
	}

local $adminurl = $url."/install.php";
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
return (1, "DaDaBIK installation complete. It can be configured at <a target=_blank href='$adminurl'>$adminurl</a>.", "Under $rp using $dbphptype database $dbname", $url);
}

# script_dadabik_uninstall(&domain, version, &opts)
# Un-installs a DaDaBIK installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_dadabik_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all dadabik_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "dadabik_");
&cleanup_script_database($d, $opts->{'db'}, [ "example" ])
	if ($opts->{'created_example'});

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "DaDaBIK directory and tables deleted.");
}

# script_dadabik_check_latest(version)
# Checks if some version is the latest for this project, and if not returns
# a newer one. Otherwise returns undef.
#sub script_dadabik_check_latest
#{
#local ($ver) = @_;
#if ($ver < 4) {
#	return undef;	# Cannot get old versions from SF
#	}
#local $re = $ver >= 4 ? "dadabik_(4\\.[0-9\\.]+)\\.zip"
#		      : "dadabik_(3\\.[0-9\\.]+)\\.zip";
#local @vers = &osdn_package_versions("dadabik", $re);
#return "Failed to find versions" if (!@vers);
#@vers = grep { !/_pl/ } @vers;
#return $ver eq $vers[0] ? undef : $vers[0];
#}

# script_dadabik_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_dadabik_php_vars
{
return ( [ 'magic_quotes_gpc', 'On' ] );
}

sub script_dadabik_site
{
return 'http://www.dadabik.org/';
}

1;

