
@autoload_tables = (
	"TABLE_PAYPAL",
	"TABLE_PAYPAL_CHECKOUT",
	"TABLE_PAYPAL_PAYMENT_STATUS_HISTORY",
	"action_recorder",
	"address_book",
	"address_format",
	"administrators",
	"banners",
	"banners_history",
	"categories",
	"categories_description",
	"configuration",
	"configuration_group",
	"counter",
	"counter_history",
	"countries",
	"currencies",
	"customers",
	"customers_basket",
	"customers_basket_attributes",
	"customers_info",
	"geo_zones",
	"languages",
	"manufacturers",
	"manufacturers_info",
	"newsletters",
	"orders",
	"orders_products",
	"orders_products_attributes",
	"orders_products_download",
	"orders_status",
	"orders_status_history",
	"orders_total",
	"products",
	"products_attributes",
	"products_attributes_download",
	"products_description",
	"products_images",
	"products_notifications",
	"products_options",
	"products_options_values",
	"products_options_values_to_products_options",
	"products_to_categories",
	"reviews",
	"reviews_description",
	"sec_directory_whitelist",
	"sessions",
	"specials",
	"tax_class",
	"tax_rates",
	"whos_online",
	"zones",
	"zones_to_geo_zones",
	"abx_api_queue",
	"abx_basket",
	"abx_configuration",
	"abx_feedback_state",
	"abx_fixed_shipping",
	"abx_houses",
	"abx_items",
	"abx_listings",
	"abx_products_extra_info",
	"abx_schedule_info",
	"abx_seller_info",
	"abx_sites",
	"abx_uploads",
	"abx_winners",
	"abx_workflow_state",
	"admin",
	"admin_files",
	"admin_groups",
	"affiliate_affiliate",
	"affiliate_banners",
	"affiliate_banners_history",
	"affiliate_clickthroughs",
	"affiliate_news",
	"affiliate_newsletters",
	"affiliate_payment",
	"affiliate_payment_status",
	"affiliate_payment_status_history",
	"affiliate_sales",
	"featured",
	"google_checkout",
	"google_checkout_logs",
	"google_orders",
	"information",
	"orders_session_info",
	"paypal",
	"paypal_auction",
	"paypal_payment_status_history",
	"paypalipn_txn",
	"products_attributes_sets",
	"products_attributes_sets_elements",
	"products_attributes_sets_to_products",
	"products_fixed_shipping",
	"qbi_config",
	"qbi_disc",
	"qbi_groups",
	"qbi_groups_items",
	"qbi_items",
	"qbi_ot",
	"qbi_ot_disc",
	"qbi_payosc",
	"qbi_payosc_payqb",
	"qbi_payqb",
	"qbi_products_items",
	"qbi_shiposc",
	"qbi_shiposc_shipqb",
	"qbi_shipqb",
	);

# script_autoload_desc()
sub script_autoload_desc
{
return "Autoload";
}

sub script_autoload_uses
{
return ( "php" );
}

sub script_autoload_longdesc
{
return "Autoload is osCommerce with everything you need added for running an online storefront.";
}

# script_autoload_versions()
sub script_autoload_versions
{
return ( "4.7.8" );
}

sub script_autoload_abandoned
{
return 2;
}

sub script_autoload_category
{
return "Commerce";
}

sub script_autoload_php_vers
{
return ( 5 );
}

sub script_autoload_php_modules
{
return ("mysql");
}

sub script_autoload_dbs
{
return ("mysql");
}

# script_autoload_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_autoload_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for Autoload tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for Autoload tables",
		     &ui_database_select("db", undef, \@dbs, $d, "autoload"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", &substitute_scriptname_template("autoload", $d), 30, "At top level"));
	}
return $rv;
}

# script_autoload_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_autoload_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_autoload_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_autoload_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/index.php") {
	return "Autoload appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
foreach my $t (@autoload_tables) {
	local $clash = &find_database_table($dbtype, $dbname, $t);
	$clash && return "Autoload appears to be already using the selected database (table $clash)";
	}
return undef;
}

# script_autoload_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_autoload_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	   'file' => "autoload-$ver.zip",
	   'virtualmin' => 1,
	   'nocheck' => 1,
	   'url' => "http://www.autoload.org/autosell/download/autoload.zip" } );
return @files;
}

sub script_autoload_commands
{
return ("unzip");
}

# script_autoload_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs Autoload, and returns either 1 and an informational
# message, or 0 and an error
sub script_autoload_install
{
local ($d, $version, $opts, $files, $upgrade) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Extract tar file to temp dir and copy to target
local $cfile = "$opts->{'dir'}/includes/configure.php";
local $admincfile = "$opts->{'dir'}/admin/includes/configure.php";
foreach my $cf ($cfile, $admincfile) {
	&set_permissions_as_domain_user($d, 0700, $cf);
	}
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "autoload");
$err && return (0, "Failed to extract source : $err");

# Update config files
foreach my $cf ($cfile, $admincfile) {
	local $lref = &read_file_lines_as_domain_user($d, $cf);
	local $l;
	local $path = $opts->{'path'} eq '/' ? '/' : $opts->{'path'}.'/';
	foreach $l (@$lref) {
		if ($l =~ /define\('HTTP_SERVER'/) {
			$l = "define('HTTP_SERVER', 'http://$d->{'dom'}');";
			}
		if ($l =~ /define\('HTTPS_SERVER'/) {
			$l = "define('HTTPS_SERVER', 'https://$d->{'dom'}');";
			}
		if ($l =~ /define\('ENABLE_SSL'/ && $d->{'ssl'}) {
			$l = "define('ENABLE_SSL', true);";
			}
		if ($l =~ /define\('DIR_WS_IMAGES'/) {
			if ($cf eq $admincfile) {
				$l = "define('DIR_WS_IMAGES', '${path}admin/images/');";
				}
			else {
				$l = "define('DIR_WS_IMAGES', '${path}images/');";
				}
			}
		if ($l =~ /define\('DIR_WS_HTTP_CATALOG'/) {
			$l = "define('DIR_WS_HTTP_CATALOG', '${path}/');";
			}
		if ($l =~ /define\('DIR_WS_HTTPS_CATALOG'/) {
			$l = "define('DIR_WS_HTTPS_CATALOG', '${path}/');";
			}
		if ($l =~ /define\('DIR_WS_CATALOG'/) {
			$l = "define('DIR_WS_CATALOG', '${path}/');";
			}
		if ($l =~ /define\('DIR_WS_ADMIN'/) {
			$l = "define('DIR_WS_ADMIN', '${path}/admin/');";
			}
		if ($l =~ /define\('DIR_FS_DOCUMENT_ROOT'/) {
			local $pub = &public_html_dir($d);
			$l = "define('DIR_FS_DOCUMENT_ROOT', '$pub');";
			}
		if ($l =~ /define\('DB_SERVER'/) {
			$l = "define('DB_SERVER', '$dbhost');";
			}
		if ($l =~ /define\('DB_SERVER_USERNAME'/) {
			$l = "define('DB_SERVER_USERNAME', '$dbuser');";
			}
		if ($l =~ /define\('DB_SERVER_PASSWORD'/) {
			$l = "define('DB_SERVER_PASSWORD', '".
			     &php_quotemeta($dbpass)."');";
			}
		if ($l =~ /define\('DB_DATABASE'/) {
			$l = "define('DB_DATABASE', '$dbname');";
			}
		}
	&flush_file_lines_as_domain_user($d, $cf);
	&set_permissions_as_domain_user($d, 0500, $cf);
	}

if (!$upgrade) {
	# Run SQL setup scripts
	&require_mysql();
	local $sqlfile = "$opts->{'dir'}/install/autoload.sql";
	($ex, $out) = &mysql::execute_sql_file($dbname, $sqlfile, $dbuser, $dbpass);
	$ex && return (0, "Failed to run database setup script : <tt>$out</tt>.");
	}

# Remove install directory
&run_as_domain_user($d, "rm -rf ".quotemeta("$opts->{'dir'}/install"));

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."admin/";
return (1, "Autoload installation complete. It can be accessed at <a target=_blank href='$url'>$url</a>, and managed at <a target=_blank href='$adminurl'>$adminurl</a>.", "Under $rp using $dbphptype database $dbname", $url);
}

# script_autoload_uninstall(&domain, version, &opts)
# Un-installs an Autoload installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_autoload_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all autoload tables from the database
&cleanup_script_database($d, $opts->{'db'}, \@autoload_tables);

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "Autoload directory and tables deleted.");
}

# script_autoload_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_autoload_php_vars
{
return ( [ 'register_globals', 'On' ] );
}

# script_autoload_latest()
# Returns a URL and regular expression or callback func to get the version
#sub script_autoload_latest
#{
#return ( "http://www.autoload.org/",
#	 'stable version:.* ([0-9\\.]+)<\/span>' );
#}

#sub script_autoload_site
#{
#return 'http://www.autoload.org/';
#}

1;

