
# script_opencartvqmod_desc()
sub script_opencartvqmod_desc
{
return "OpenCart + VQMod";
}

sub script_opencartvqmod_uses
{
return ( "php" );
}

sub script_opencartvqmod_longdesc
{
return "A powerful open-source shopping cart system that is designed to be feature rich and user friendly. This version is pre-installed with VQMod v2.4.1";
}

# script_opencartvqmod_versions()
sub script_opencartvqmod_versions
{
return ( "1.5.6" );
}

sub script_opencartvqmod_category
{
return "Commerce";
}

sub script_opencartvqmod_php_vers
{
return ( 5 );
}

sub script_opencartvqmod_php_modules
{
return ("mysql", "curl");
}

sub script_opencartvqmod_dbs
{
return ("mysql");
}

# script_opencartvqmod_php_vars(&domain)
# Returns an array of extra PHP variables needed for this script
sub script_opencartvqmod_php_vars
{
return ( [ 'magic_quotes_gpc', 'Off' ] );
}

# script_opencartvqmod_params(&domain, version, &upgrade-info)
# Returns HTML for table rows for options for installing Wordpress
sub script_opencartvqmod_params
{
local ($d, $ver, $upgrade) = @_;
local $rv;
local $hdir = &public_html_dir($d, 1);
if ($upgrade) {
	# Options are fixed when upgrading
	local ($dbtype, $dbname) = split(/_/, $upgrade->{'opts'}->{'db'}, 2);
	$rv .= &ui_table_row("Database for OpenCart tables", $dbname);
	local $dir = $upgrade->{'opts'}->{'dir'};
	$dir =~ s/^$d->{'home'}\///;
	$rv .= &ui_table_row("Install directory", $dir);
	}
else {
	# Show editable install options
	local @dbs = &domain_databases($d, [ "mysql" ]);
	$rv .= &ui_table_row("Database for OpenCart tables",
		     &ui_database_select("db", undef, \@dbs, $d, "opencart"));
	$rv .= &ui_table_row("Install sub-directory under <tt>$hdir</tt>",
			     &ui_opt_textbox("dir", "opencart", 30,
					     "At top level"));
	}
return $rv;
}

# script_opencartvqmod_parse(&domain, version, &in, &upgrade-info)
# Returns either a hash ref of parsed options, or an error string
sub script_opencartvqmod_parse
{
local ($d, $ver, $in, $upgrade) = @_;
if ($upgrade) {
	# Options are always the same
	return $upgrade->{'opts'};
	}
else {
	local $hdir = &public_html_dir($d, 0);
	$in{'dir_def'} || $in{'dir'} =~ /\S/ && $in{'dir'} !~ /\.\./ ||
		return "Missing or invalid installation directory";
	local $dir = $in{'dir_def'} ? $hdir : "$hdir/$in{'dir'}";
	local ($newdb) = ($in->{'db'} =~ s/^\*//);
	return { 'db' => $in->{'db'},
		 'newdb' => $newdb,
		 'dir' => $dir,
		 'path' => $in{'dir_def'} ? "/" : "/$in{'dir'}", };
	}
}

# script_opencartvqmod_check(&domain, version, &opts, &upgrade-info)
# Returns an error message if a required option is missing or invalid
sub script_opencartvqmod_check
{
local ($d, $ver, $opts, $upgrade) = @_;
$opts->{'dir'} =~ /^\// || return "Missing or invalid install directory";
$opts->{'db'} || return "Missing database";
if (-r "$opts->{'dir'}/config.php") {
	return "OpenCart appears to be already installed in the selected directory";
	}
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $clash = &find_database_table($dbtype, $dbname, "opencart_.*");
$clash && return "OpenCart appears to be already using the selected database (table $clash)";
return undef;
}

# script_opencartvqmod_files(&domain, version, &opts, &upgrade-info)
# Returns a list of files needed by Wordpress, each of which is a hash ref
# containing a name, filename and URL
sub script_opencartvqmod_files
{
local ($d, $ver, $opts, $upgrade) = @_;
local @files = ( { 'name' => "source",
	'file' => "opencart-${ver}_plus_vqmod-2.4.1.zip",
	'url' => "http://www.questodia.nl/images/downloads/opencart-${ver}_plus_vqmod-2.4.1.zip" } );
return @files;
}

sub script_opencartvqmod_commands
{
return ("unzip");
}

# script_opencartvqmod_install(&domain, version, &opts, &files, &upgrade-info)
# Actually installs OpenCart, and returns either 1 and an informational
# message, or 0 and an error
sub script_opencartvqmod_install
{
local ($d, $version, $opts, $files, $upgrade, $domuser, $dompass) = @_;
local ($out, $ex);
if ($opts->{'newdb'} && !$upgrade) {
        local $err = &create_script_database($d, $opts->{'db'});
        return (0, "Database creation failed : $err") if ($err);
        }
local ($dbtype, $dbname) = split(/_/, $opts->{'db'}, 2);
local $dbuser = &mysql_user($d);
local $dbpass = &mysql_pass($d);
local $dbhost = &get_database_host("mysql");
local $dberr = &check_script_db_connection($dbtype, $dbname, $dbuser, $dbpass);
return (0, "Database connection failed : $dberr") if ($dberr);

# Backup config file
local $cfile = "$opts->{'dir'}/config.php";
local $admin_cfile = "$opts->{'dir'}/admin/config.php";
local $cfile_temp = &transname();
local $admin_cfile_temp = &transname();
if ($upgrade) {
	&copy_source_dest($cfile, $cfile_temp);
	&copy_source_dest($admin_cfile, $admin_cfile_temp);
	}

# Extract tar file to temp dir and copy to target
local $temp = &transname();
local $err = &extract_script_archive($files->{'source'}, $temp, $d,
                                     $opts->{'dir'}, "opencart-*/upload");
$err && return (0, "Failed to extract source : $err");

# Put back config files
if ($upgrade) {
	&copy_source_dest_as_domain_user($d, $cfile_temp, $cfile);
	&copy_source_dest_as_domain_user($d, $admin_cfile_temp, $admin_cfile);
}
else {
	&copy_source_dest_as_domain_user($d, "$opts->{'dir'}/config-dist.php", $cfile);
	&copy_source_dest_as_domain_user($d, "$opts->{'dir'}/admin/config-dist.php", $admin_cfile);
}

# Make important files writeable
&make_file_php_writable($d, "$opts->{'dir'}/image", 1);
&make_file_php_writable($d, "$opts->{'dir'}/image/cache", 1);
&make_file_php_writable($d, "$opts->{'dir'}/image/data", 1);
&make_file_php_writable($d, "$opts->{'dir'}/system/cache", 1);
&make_file_php_writable($d, "$opts->{'dir'}/system/logs", 1);
&make_file_php_writable($d, "$opts->{'dir'}/download", 1);
&make_file_php_writable($d, "$opts->{'dir'}/config.php", 0);
&make_file_php_writable($d, "$opts->{'dir'}/admin/config.php", 0);

if (!$upgrade) {
	# Call the DB setup page
	local @params = (
		[ "db_driver", "mysql" ],
		[ "db_host", $dbhost ],
		[ "db_user", $dbuser ],
		[ "db_password", $dbpass ],
		[ "db_name", $dbname ],
		[ "db_prefix", "opencart_" ],
		[ "username", $domuser ],
		[ "password", $dompass ],
		[ "email", $d->{'emailto'} ],
		);
	local $params = join("&", map { $_->[0]."=".&urlize($_->[1]) } @params);
	local $ipage = $opts->{'path'}."/install/index.php?route=step_3";
	local ($out, $error);
	&post_http_connection($d, $ipage, $params, \$out, \$error);
	if ($error) {
		return (-1, "Database setup failed : $error");
		}
	if ($out !~ /Congratulations/) {
		return (-1, "Database setup failed");
		}
	}

# Delete the install dir
&unlink_file_as_domain_user($d, "$opts->{'dir'}/install");

# Return a URL for the user
local $url = &script_path_url($d, $opts);
local $rp = $opts->{'dir'};
$rp =~ s/^$d->{'home'}\///;
local $adminurl = $url."admin";
return (1, "OpenCart installation complete. It can be managed at <a target=_blank href='$adminurl'>$adminurl</a> .", "Under $rp using $dbphptype database $dbname", $url, $domuser, $dompass);
}

# script_opencart_uninstall(&domain, version, &opts)
# Un-installs a Wordpress installation, by deleting the directory and database.
# Returns 1 on success and a message, or 0 on failure and an error
sub script_opencartvqmod_uninstall
{
local ($d, $version, $opts) = @_;

# Remove the contents of the target directory
local $derr = &delete_script_install_directory($d, $opts);
return (0, $derr) if ($derr);

# Remove all opencartvqmod_ tables from the database
&cleanup_script_database($d, $opts->{'db'}, "opencart_");

# Take out the DB
if ($opts->{'newdb'}) {
        &delete_script_database($d, $opts->{'db'});
        }

return (1, "OpenCart directory and tables deleted.");
}

# script_opencartvqmod_latest(version)
# Returns a URL and regular expression or callback func to get the version
sub script_opencartvqmod_latest
{
local ($ver) = @_;
return ( "http://www.opencart.com/index.php?route=download/download",
	 "v([0-9]+\\.[0-9\\.]+)" );
}

sub script_opencartvqmod_site
{
return 'http://www.opencart.com/';
}

sub script_opencartvqmod_passmode
{
return 1;
}

1;

